# One-to-Many Communication and Compositionality in Emergent Communication

This repository contains the code for the paper <em>One-to-Many Communication and Compositionality in Emergent Communication</em>.

# Setup

## Install packages

```bash
conda env create --name one_to_many --file environment.yml
```

## Download ImageNet dataset

Follow instructions in [this document](https://github.com/google-deepmind/emergent_communication_at_scale?tab=readme-ov-file#downloading-dataset) and place the dataset under `data/byol_imagenet2012` directory.

# Run naive one-to-many experiments

```bash
python scripts_official/diff_int/duplicate.sh
```

# Run listeners of different interests experiments

```bash
python scripts_official/diff_int/diverse.sh
```

# Run coordination pressure experiments

```bash
python scripts_official/coordination/duplicate_50n.sh
```

# Run iterated learning experiments

## No-rest regime

```bash
python scripts_official/iterated/no_reset_1n.sh
python scripts_official/iterated/no_reset_2n.sh
```

## Simultaneous reset regime

```bash
python scripts_official/iterated/simul_1n.sh
python scripts_official/iterated/simul_2n.sh
```

## Uniform reset regime

```bash
python scripts_official/iterated/unif_1n.sh
python scripts_official/iterated/unif_2n.sh
```

# Run general one-to-many communication experiments

## Single-interest formation

```bash
python scripts_official/coordination/diverse_1.sh
```

## Mixed-interest formation

```bash
python scripts_official/coordination/diverse_4_1.sh
```

## Full-interest formation

```bash
python scripts_official/coordination/duplicate_5n.sh
```

# Run 3dshapes experiments

## Listeners of different interests

```bash
python scripts_official/3dshapes/diverse.sh
```

## Naive one-to-many

```bash
python scripts_official/3dshapes/duplicate.sh
```

# Run image discrimination experiments

```bash
python scripts_official/disc/no_reset_10n_full.sh
```

# Acknowledgement

The code is based on [EGG](https://github.com/facebookresearch/EGG) framework. We thank the authors for sharing the codebase.