package com.zhaohanphd;

import weka.core.Instances;

public class CustomEvaluation extends weka.classifiers.evaluation.Evaluation{

	/**
	 * 
	 */
	private static final long serialVersionUID = 100L;

	public CustomEvaluation(Instances data) throws Exception {
		super(data);
	}

	// do not divide non-predicted class
	public double weightedPrecision() {
		double[] trueClassCounts = trueClassCounts();
		double[] predictedClassCounts = predictedClassCounts();
		double precisionTotal = 0;
		for (int i = 0; i < m_NumClasses; i++) {
			if (trueClassCounts[i] > 0 && predictedClassCounts[i] != 0) { // If precision is NaN, we want the sum to
																			// also be NaN if count > 0

				precisionTotal += (numTruePositives(i) / predictedClassCounts[i]) * trueClassCounts[i];
			}
		}

		return precisionTotal / numClassified();
	}
	
	// do not divide non-predicted class
	public double weightedFMeasure() {
		double[] trueClassCounts = trueClassCounts();
		double[] predictedClassCounts = predictedClassCounts();
		double fMeasureTotal = 0;
		for (int i = 0; i < m_NumClasses; i++) {
			if (trueClassCounts[i] > 0 && predictedClassCounts[i] != 0) {
				fMeasureTotal += fMeasure(numTruePositives(i) / predictedClassCounts[i],
						numTruePositives(i) / trueClassCounts[i]) * trueClassCounts[i];
			}
		}
		
		return fMeasureTotal / numClassified();
	}

	public int coverage() {
		int coverage = 0;
		for (int i = 0; i < m_NumClasses; i++) {
			if (numPositives(i) + numNegatives(i) != 0) {
				coverage++;
			}
		}
		return coverage;
	}
}
