# Diff-level-adv-training
## train
- static
`python main.py --mode train --evaluation_data_type test --training_type l2rew --sgd_lr 2e-5 --epochs 10 --batch_size 32 --epsilon 1e-8 --valid_batch_size 32 --augment_ratio 0.5 --seed 42 --valid_iter 10 --alpha 0 --epochs_update_valid 10 --dataset_name sst2 --attack_model_path base-len128-epo10-batch32-lrate2e-05-last --base_aug True`
- dynamic
`python main.py --mode train --evaluation_data_type test --training_type l2rew --sgd_lr 2e-5 --epochs 10 --batch_size 32 --epsilon 1e-8 --valid_batch_size 32 --augment_ratio 0.5 --seed 42 --valid_iter 10 --alpha 0 --epochs_update_valid 1 --dataset_name sst2 --base_aug False`
## attack
- attack model at last epoch
`python main.py --mode attack --use_benchmark False --modify_ratio 0.2 --attack_method textfooler --evaluation_data_type test --training_type l2rew --sgd_lr 2e-5 --attack_epoch_type last --epochs 10 --batch_size 32 --epsilon 1e-8 --valid_batch_size 32 --augment_ratio 0.5 --seed 42 --valid_iter 10 --alpha 0 --epochs_update_valid 10 --dataset_name sst2 --attack_model_path base-len128-epo10-batch32-lrate2e-05-last --base_aug True`
- attack model at epoch 5
`python main.py --mode attack_epochs --attack_epoch 4 --use_benchmark False --modify_ratio 0.2 --attack_method textfooler --evaluation_data_type test --training_type l2rew --sgd_lr 2e-5 --attack_epoch_type last --epochs 10 --batch_size 32 --epsilon 1e-8 --valid_batch_size 32 --augment_ratio 0.5 --seed 42 --valid_iter 10 --alpha 0 --epochs_update_valid 10 --dataset_name sst2 --attack_model_path base-len128-epo10-batch32-lrate2e-05-last --base_aug True`
## evaluate
- evaluate model with the best performance among epochs
`python main.py --mode evaluate --evaluation_data_type test --training_type l2rew --sgd_lr 2e-5 --epochs 10 --batch_size 32 --epsilon 1e-8 --valid_batch_size 32 --augment_ratio 0.5 --seed 42 --valid_iter 10 --alpha 0 --epochs_update_valid 10 --dataset_name sst2 --attack_model_path base-len128-epo10-batch32-lrate2e-05-last --base_aug True`
- evaluate the model at last epoch
`python main.py --mode eval_last --use_benchmark False --modify_ratio 0.2 --attack_method textfooler --evaluation_data_type test --training_type l2rew --sgd_lr 2e-5 --attack_epoch_type last --epochs 10 --batch_size 32 --epsilon 1e-8 --valid_batch_size 32 --augment_ratio 0.5 --seed 42 --valid_iter 10 --alpha 0 --epochs_update_valid 10 --dataset_name sst2 --attack_model_path base-len128-epo10-batch32-lrate2e-05-last --base_aug True`
`python main.py --mode evaluate --use_benchmark False --modify_ratio 0.2 --attack_method textfooler --evaluation_data_type test --training_type l2rew --sgd_lr 2e-5 --attack_epoch_type last --epochs 10 --batch_size 32 --epsilon 1e-8 --valid_batch_size 32 --augment_ratio 0.5 --seed 42 --valid_iter 10 --alpha 0 --epochs_update_valid 10 --dataset_name sst2 --attack_model_path base-len128-epo10-batch32-lrate2e-05-last --base_aug True --evaluation_model_type last`
- evaluate the model at epoch 5
`python main.py --mode eval_last --use_benchmark False --modify_ratio 0.2 --attack_method textfooler --evaluation_data_type test --training_type l2rew --sgd_lr 2e-5 --attack_epoch_type last --epochs 10 --batch_size 32 --epsilon 1e-8 --valid_batch_size 32 --augment_ratio 0.5 --seed 42 --valid_iter 10 --alpha 0 --epochs_update_valid 10 --dataset_name sst2 --attack_model_path base-len128-epo10-batch32-lrate2e-05-last --base_aug True --eval_epoch 4`