import matplotlib.pyplot as plt
import numpy as np
import matplotlib.animation as animation

def main():
    numframes = 100
    numpoints = 10
    color_data = np.random.random((numframes, numpoints))
    x, y, c = np.random.random((3, numpoints))

    # fig = plt.figure()
    fig, ax = plt.subplots()
    scat = plt.scatter(x, y, c=c, s=100)

    text = ax.text(0,0,0)
    ani = animation.FuncAnimation(fig, update_plot, frames=xrange(numframes),
                                  fargs=(color_data, scat, text))
    plt.show()

def update_plot(i, data, scat, text):
    numpoints = 10
    text.set_text(str(i))
    x, y, c = np.random.random((3, numpoints))
    # scat.set_array(x)
    scat.set_offsets(np.vstack([x,y]).T)
    return scat,

main()
