from nltk.corpus import wordnet as wn
from file_ids_e114 import df_ids, nw_ids
import os
from best.loaders import *


POSITIVE_LEXICON_THREE_POINTS = set()
POSITIVE_LEXICON_TWO_POINTS = set()
POSITIVE_LEXICON_ONE_POINTS = set()
NEGATIVE_LEXICON_THREE_POINTS = set()
NEGATIVE_LEXICON_TWO_POINTS = set()
NEGATIVE_LEXICON_ONE_POINTS = set()

def lexicon_generator():
    positive_seeds = ['good', 'great', 'wonderful', 'success','joy', 'happy', 'amazing', 'exuberance']
    negative_seeds = ['bad','terrible','tragic','horrible','fail','death','pain','sorrow']
    for seed_pos in positive_seeds:
        POSITIVE_LEXICON_THREE_POINTS.add(seed_pos)
    for seed_neg in negative_seeds:
        NEGATIVE_LEXICON_THREE_POINTS.add(seed_neg)
    for element_of_3 in POSITIVE_LEXICON_THREE_POINTS:
        # Assume the first meaning is the one we want
        meaning_of_choice_3 = wn.synsets(element_of_3)[0]
        for lemma_3 in meaning_of_choice_3.lemmas():
            if lemma_3.name() not in POSITIVE_LEXICON_THREE_POINTS:
                POSITIVE_LEXICON_TWO_POINTS.add(lemma_3.name())
    for element_of_2 in POSITIVE_LEXICON_TWO_POINTS:
        # Assume the first meaning is the one we want
        meaning_of_choice_2 = wn.synsets(element_of_2)[0]
        for lemma_2 in meaning_of_choice_2.lemmas():
            if lemma_2.name() not in POSITIVE_LEXICON_TWO_POINTS and lemma_2.name() not in POSITIVE_LEXICON_THREE_POINTS:
                POSITIVE_LEXICON_ONE_POINTS.add(lemma_2.name())
    for element_of_3 in NEGATIVE_LEXICON_THREE_POINTS:
        # Assume the first meaning is the one we want
        meaning_of_neg_choice_3 = wn.synsets(element_of_3)[0]
        for lemma_3 in meaning_of_neg_choice_3.lemmas():
            if lemma_3.name() not in NEGATIVE_LEXICON_THREE_POINTS:
                NEGATIVE_LEXICON_TWO_POINTS.add(lemma_3.name())
    for element_of_2 in NEGATIVE_LEXICON_TWO_POINTS:
        # Assume the first meaning is the one we want
        meaning_of_neg_choice_2 = wn.synsets(element_of_2)[0]
        for lemma_2 in meaning_of_neg_choice_2.lemmas():
            if lemma_2.name() not in NEGATIVE_LEXICON_TWO_POINTS and lemma_2.name() not in NEGATIVE_LEXICON_THREE_POINTS:
                NEGATIVE_LEXICON_ONE_POINTS.add(lemma_2.name())


def target_producer(tokens, directory, data_root):
    doc_id = tokens[-1]
    tokens = tokens[:-1]
    score = 0
    for token in tokens:
        if token in POSITIVE_LEXICON_THREE_POINTS:
            score = score + 3
        if token in POSITIVE_LEXICON_TWO_POINTS:
            score = score + 2
        if token in POSITIVE_LEXICON_ONE_POINTS:
            score = score + 1
        if token in NEGATIVE_LEXICON_THREE_POINTS:
            score = score - 3
        if token in NEGATIVE_LEXICON_TWO_POINTS:
            score = score - 2
        if token in NEGATIVE_LEXICON_ONE_POINTS:
            score = score - 1

    if doc_id in df_ids:
        f = open(os.path.join(data_root,
                              directory,
                              ('{}.sentiment.txt'.format(doc_id))), 'w+')
        if score > 0:
            f.write('Positive')
        else:
            f.write('Negative')
        f.write(str(score))
    if doc_id in nw_ids:
        f = open(os.path.join(data_root,
                              directory,
                              ('{}.sentiment.txt'.format(doc_id))), 'w+')
        if score > 0:
            f.write('Positive')
        else:
            f.write('Negative')
        f.write(str(score))
