import os
import timeit
from operator import itemgetter

import nltk
import sqlalchemy
from sklearn.utils import random
from sklearn import svm, model_selection
import pickle
import re
import os
from pandas.plotting import scatter_matrix
import pandas as pd
import numpy as np
import scipy
import math
import matplotlib.pyplot as plt

from CTestGeneratorStrategy import CTestGeneratorStrategy


class GapSelectionStrategy(CTestGeneratorStrategy):
    '''
    This is a implemenation of a ctest generation startegy called "Gap Selection".
    This Strategy selects 20 out of 40 possible Gaps which fit the most to the desired difficulty.
    '''
    file_inc = 'model_inc'
    file_dec = 'model_dec'

    def generateContextSents(self, ctest, sentence):
        '''
        This method appends a sentece which should not be mutilated by gaps in the DKPro TC Format.
        :param ctest:Token-List of ctest in DKPro TC format
        :param sentence: Sentece to add
        :return:List with added sentece
        '''
        token = nltk.word_tokenize(sentence)
        if not ctest:
            if len(token) > 20:
                [ctest.append(t + "\n") for t in token[-20:]]
            else:
                [ctest.append(t + "\n") for t in token]
        else:
            if len(token) > 20:
                [ctest.append(t + "\n") for t in token[:20]]
            else:
                [ctest.append(t + "\n") for t in token]
        ctest.append("----\n")





    def generate_ctest(self, txt,gap_ids,N):
        '''
        This method generates a ctest in the DKPro TC Format according to the Gap Selection strategy.
        The startegy suggests to generate a ctest with a preselection of which candidate should be a gap.
        Candidates are all normal words with more than two character.
        The first and the last sentece have no mutilations to provide context information.
        :param txt: Text to produce ctest from
        :param gap_ids: IDs of potential Gaps which should be mutilated
        :param N: Number of desired Gaps
        :return:None if text is not appropriate for the test generation or
        ctest in TC Format and human readable ctest and all gap words as tuple if successful

        '''
        ctest_tc = []
        ctest = []
        gaps=[]
        gapId = 0
        tN = 0
        sents = [s.replace("\n", "") for s in nltk.sent_tokenize(txt)[:30]]

        if len(sents) < 2:
            print("input should contain at least 2 sentences, but only ", len(sents), "were detected")
            return

        self.generateContextSents(ctest_tc, sents[0])
        ctest.append(sents[0])
        for n, sent in enumerate(sents[1:]):
            if sents[n + 1] == None or gapId > N-1:
                self.generateContextSents(ctest_tc, sent)
                ctest.append(sent)

                return ("".join(ctest_tc), "".join(ctest),gaps)
            else:
                for i, t in enumerate(nltk.word_tokenize(sent)):
                    if t.isalpha() and not t.isupper() and len(t) > 1:
                        if tN in gap_ids and not gapId > N-1:
                            cut = int(len(t) / 2)
                            ctest_tc.append(t + "\t" + str(gapId + 1) + "\t" + t[0:cut] + "\t" + "0.0" + "\n")

                            ctest.append(" " + t[0:cut] + "_" * (len(t) - cut))
                            gaps.append(t)
                            gapId += 1
                        else:
                            ctest_tc.append(t + "\n")
                            ctest.append(" " + t)
                        tN += 1
                    else:
                        ctest_tc.append(t + "\n")
                        if t not in [".", ",", "\'", '\'', '?', '!', ';', '&', '(', ')']:
                            ctest.append(" " + t)
                        else:
                            ctest.append(t)
                ctest_tc.append("----\n")
        return None


    def retrieve_ctest(self):
        '''
        This method produces a c-test with the desired difficulty level.
        :return:ctest as tuple of tc-Format, Human readable, gaps, the average and the individual predicted difficulty.
        '''
        start = timeit.default_timer()
        text = self.texts[0]
        ctestTemp = self.generate_ctest(text,range(40),40)
        gaps=[]
        if ctestTemp is not None:
            prediction = self.predict(ctestTemp[0])
            eval=self.evaluator(prediction[0], self.targetLevel)
            diff=[(n,e) for n,e in enumerate(eval[1])]
            #positive or negative?

            while len(gaps)<21:
                pos = list(filter(lambda x: x[1] > 0 and x[0] not in gaps, diff))
                neg = list(filter(lambda x: x[1] <= 0 and x[0] not in gaps, diff))

                if len(pos)>0:
                    m= min(pos, key=itemgetter(1))[0]
                    gaps.append(m)
                if len(neg)>0:
                    m=max(neg, key=itemgetter(1))[0]
                    gaps.append(m)

            ctestTemp = self.generate_ctest(text, gaps, 20)
            prediction = self.predict(ctestTemp[0])
            print("Test generation took", timeit.default_timer() - start)
            return ctestTemp + ( sum(prediction[0]) / len(prediction[0]),prediction[0])


        print("Problem during the generation: cTest became None")
        return False

