#ifndef KEYREF_H
#define KEYREF_H

#include <functional>

template < typename T >
class KeyRef {
    friend struct std::hash< KeyRef< T > >;

private:
    T* obj_ptr_;

public:
    KeyRef()
    : obj_ptr_(nullptr) {}

    KeyRef(T& obj)
    : obj_ptr_(&obj){};

    const T& get() const { return *obj_ptr_; }
    T& get() { return *obj_ptr_; }

    bool operator<(const KeyRef& v) const {
        return *obj_ptr_ < *v.obj_ptr_;
    }

    bool operator>(const KeyRef& v) const {
        return !(*obj_ptr_ < *v.obj_ptr_);
    }

    bool operator==(const KeyRef& v) const {
        return *obj_ptr_ == *v.obj_ptr_;
    }
};

namespace std {

template < typename T >
class hash< KeyRef< T > > {
    std::size_t operator()(const KeyRef< T >& key) const {
        return std::hash< T >()(key.obj_ptr_);
    }
};
}

#endif /* KEYREF_H */

// Local Variables:
// mode: c++
// End:
