import numpy as np
import operator
import sys
import getopt
from itertools import izip




def main(sys_argv):
	try:
		opts, argv = getopt.getopt(sys_argv[1:], "ho:",["help", "output="])
	except getopt.GetoptError, err:
		print str(err)
		sys.exit(1)

    # out_file = "./transformed_wiki_800vecs_150306"

	additional = None
	for opt, val in opts:
		if opt in ("-o", "--ouput"):
			out_file = val
			print "Vectors is saved as: " + out_file

	if len(argv) == 3:
		tmVecsFilename = argv[0]	
		originalVecsFilename = argv[1]
		dictFilename = argv[2]

        #target_file = argv[3]

	else:
		print str(err)


	tmVecsFile = open(tmVecsFilename, "r")
	originalVecsFile = open(originalVecsFilename, "r")
	dictFile = open(dictFilename, "r")
	similariryFile = open(out_file, "w")

	tmVec = []
	originalVec = []
	# similarityScore = []
	allDict = []

	wordSimilarityDict = {}

	for dictLine in dictFile:
		eachDictWord = dictLine.strip()
		allDict.append(eachDictWord)

	# for eachWikiVecLine in WikiVecsFile:
	# 	eachWiki = eachWikiVecLine.strip()
	# 	wikiVec.append(eachWiki)
	# WikiVecsFile.close()

	# for eachTweetVecLine in TweetVecsFile:
	# 	eachTweet = eachTweetVecLine.strip()
	# 	tweetVec.append(eachTweet)
	# TweetVecsFile.close()

	i= 0

	for a, b in izip(tmVecsFile,originalVecsFile):
		vectorA = np.matrix(a.strip().split(),dtype=float)
		vectorB = np.matrix(b.strip().split(),dtype=float)

		row_normsA = np.sqrt(np.multiply(vectorA, vectorA).sum(1))
		row_normsA = row_normsA.astype(np.double)
		row_normsA[row_normsA != 0] = np.array(1.0/row_normsA[row_normsA != 0]).flatten()
		vectorA = np.multiply(vectorA, row_normsA)


		row_normsB = np.sqrt(np.multiply(vectorB, vectorB).sum(1))
		row_normsB = row_normsB.astype(np.double)
		row_normsB[row_normsB != 0] = np.array(1.0/row_normsB[row_normsB != 0]).flatten()
		vectorB = np.multiply(vectorB, row_normsB)

		similarityAB = vectorA*vectorB.T
		similariryFile.write("\t\t%s:%.6f\n" % (allDict[i], similarityAB))
		tempDict = {allDict[i]:similarityAB}
		wordSimilarityDict.update(tempDict)
		i+=1




	similariryFile.close

	dictFile.close


	# sorted_similarity = sorted(wordSimilarityDict.items(), key=operator.itemgetter(1), reverse=True)

	# sortedSimilarityFile = open("sorted_similarity_high2low_800vecs_150307.txt", "w")

	# for record in sorted_similarity:
	# 	sortedSimilarityFile.write("\t\t%s:%.6f\n" % (record[0], record[1]))
	# sortedSimilarityFile.close()

if __name__ == '__main__':
    main(sys.argv)