/*
 * Decompiled with CFR 0.152.
 */
package fig.servlet;

import fig.basic.IOUtils;
import fig.servlet.Field;
import fig.servlet.FieldItem;
import fig.servlet.FieldListMap;
import fig.servlet.Item;

public class FieldSpecItem
extends Item {
    public FieldSpecItem(Item parent, String name, String sourcePath) {
        super(parent, name, sourcePath);
        IOUtils.createNewFileIfNotExistsEasy(sourcePath);
    }

    public FieldSpecItem(Item parent, String name, String sourcePath, FieldListMap fields) {
        this(parent, name, null);
        this.addFields(fields);
    }

    @Override
    public FieldListMap getMetadataFields() {
        FieldListMap fields = new FieldListMap();
        fields.add("count", "Number of executions");
        fields.add((String)"description", (String)"One-line description").mutable = true;
        return fields;
    }

    @Override
    public FieldListMap getItemsFields() {
        return new FieldItem(null, null).getMetadataFields();
    }

    public void addToFieldListMap(FieldListMap fields) {
        for (Item item : this.items.values()) {
            if (item instanceof FieldItem) {
                fields.add(((FieldItem)item).createField());
                continue;
            }
            if (!(item instanceof FieldSpecItem)) continue;
            ((FieldSpecItem)item).addToFieldListMap(fields);
        }
    }

    public FieldListMap createFieldListMap() {
        FieldListMap fields = new FieldListMap();
        this.addToFieldListMap(fields);
        return fields.sort();
    }

    public void addFields(FieldListMap fields) {
        for (Field field : fields.values()) {
            FieldItem item = (FieldItem)this.newItem(field.name);
            item.setFromField(field);
            this.addItem(item);
        }
    }

    @Override
    protected void addItem(Item item) {
        if (item instanceof FieldItem) {
            Field field = ((FieldItem)item).createField();
            item = this.newItem(item.name);
            ((FieldItem)item).setFromField(field);
        }
        super.addItem(item);
    }

    @Override
    protected boolean namesAreIndices() {
        return false;
    }

    @Override
    protected boolean isView() {
        return true;
    }

    @Override
    public Item newItem(String name) {
        return new FieldItem(this, name);
    }
}

