/*
 * Decompiled with CFR 0.152.
 */
package LinguaView.syntax;

import LinguaView.TreePanel;
import LinguaView.syntax.Atomic;
import LinguaView.syntax.AttributeValueMatrix;
import LinguaView.syntax.SemanticForm;
import LinguaView.syntax.SetOfAttributeValueMatrix;
import LinguaView.syntax.Value;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Set;

public class FeatureLayoutPanel
extends TreePanel<AttributeValueMatrix> {
    int nodesCount;
    IdentityHashMap<AttributeValueMatrix, Integer> indexTable;
    AttributeValueMatrix[] nodesArray;
    int[] XLeftArray;
    int[] XBoarderLineArray;
    int[] XRightArray;
    int[] YUpArray;
    int[] YDownArray;
    int XLeftMargin;
    int XBoarderLineMargin;
    int CurlyBracketMargin;
    int XRightMargin;
    int RefLineMargin;
    int RefLineHeight;
    HashMap<Value, Integer> YFeatureTable = new HashMap();
    ArrayList<AttributeValueMatrix> RefList = new ArrayList();

    @Override
    public void init() {
        this.loadFont();
        this.loadSentence();
        this.setPreferredSize(this.area);
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.render(g2);
    }

    @Override
    public void render(Graphics2D g2) {
        g2.setFont(this.font);
        g2.setColor(Color.BLACK);
        g2.setStroke(new BasicStroke());
        int i = 0;
        while (i < this.nodesCount) {
            if (this.containedInRefList(this.nodesArray[i])) {
                AttributeValueMatrix realVal = AttributeValueMatrix.getRealContent(this.nodesArray[i]);
                int j = this.indexTable.get(this.nodesArray[i]);
                int k = this.indexTable.get(realVal);
                int x2 = this.XRightArray[j];
                int y2 = (this.YUpArray[j] + this.YDownArray[j]) / 2;
                int x1 = this.XRightArray[k];
                int y1 = (this.YUpArray[k] + this.YDownArray[k]) / 2;
                this.drawRefLine(x1, y1, x2, y2, this.RefLineHeight, g2);
            } else if (this.YUpArray[i] != 0) {
                AttributeValueMatrix avm = this.nodesArray[i];
                Set<String> Keys = avm.getAllAttributeNames();
                if (!this.containedInRefList(avm)) {
                    this.drawLeftSquareBracket(this.XLeftArray[i], this.YUpArray[i], this.YDownArray[i], g2);
                    this.drawRightSquareBracket(this.XRightArray[i], this.YUpArray[i], this.YDownArray[i], g2);
                }
                for (String Key2 : Keys) {
                    Value Val = avm.getAttributeValue(Key2);
                    int YPos = this.YFeatureTable.get(Val);
                    if (Val instanceof Atomic) {
                        g2.drawString(Key2, this.XLeftArray[i] + this.XLeftMargin, YPos += this.fontHight);
                        g2.drawString(((Atomic)Val).getValue(), this.XBoarderLineArray[i], YPos);
                        continue;
                    }
                    if (Val instanceof SemanticForm) {
                        YPos += this.fontHight;
                        String sfStr = "'";
                        sfStr = String.valueOf(sfStr) + ((SemanticForm)Val).getPred();
                        sfStr = String.valueOf(sfStr) + " <";
                        String[] stringArray = ((SemanticForm)Val).getStringArgs();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String arg = stringArray[n2];
                            sfStr = String.valueOf(sfStr) + arg;
                            sfStr = String.valueOf(sfStr) + ", ";
                            ++n2;
                        }
                        if (sfStr.lastIndexOf(", ") != -1) {
                            sfStr = sfStr.substring(0, sfStr.lastIndexOf(", "));
                        }
                        sfStr = String.valueOf(sfStr) + ">'";
                        g2.drawString(Key2, this.XLeftArray[i] + this.XLeftMargin, YPos);
                        g2.drawString(sfStr, this.XBoarderLineArray[i], YPos);
                        continue;
                    }
                    if (Val instanceof AttributeValueMatrix) {
                        if (!this.containedInRefList(Val)) {
                            Val = AttributeValueMatrix.getRealContent((AttributeValueMatrix)Val);
                        }
                        int j = this.indexTable.get((AttributeValueMatrix)Val);
                        YPos = (this.YUpArray[j] + this.YDownArray[j]) / 2;
                        g2.drawString(Key2, this.XLeftArray[i] + this.XLeftMargin, YPos);
                        continue;
                    }
                    if (!(Val instanceof SetOfAttributeValueMatrix)) continue;
                    Set<AttributeValueMatrix> avmset = ((SetOfAttributeValueMatrix)Val).getSet();
                    int XRightPos = 0;
                    int YDownPos = 0;
                    for (AttributeValueMatrix e : avmset) {
                        int j = this.indexTable.get(e = AttributeValueMatrix.getRealContent(e));
                        if (this.YDownArray[j] > YDownPos) {
                            YDownPos = this.YDownArray[j];
                        }
                        if (this.XRightArray[j] <= XRightPos) continue;
                        XRightPos = this.XRightArray[j];
                    }
                    YDownPos = (int)((double)YDownPos + this.levelSize);
                    g2.drawString(Key2, this.XLeftArray[i] + this.XLeftMargin, (YPos + YDownPos) / 2);
                    this.drawLeftCurlyBracket(this.XBoarderLineArray[i], YPos, (int)((double)YDownPos - this.levelSize), g2);
                    this.drawRightCurlyBracket(XRightPos + this.CurlyBracketMargin, YPos, (int)((double)YDownPos - this.levelSize), g2);
                }
            }
            ++i;
        }
    }

    private boolean containedInRefList(Object avm) {
        for (AttributeValueMatrix e : this.RefList) {
            if (avm != e) continue;
            return true;
        }
        return false;
    }

    private void drawLeftSquareBracket(int x, int y1, int y2, Graphics2D g2) {
        Font g2font = g2.getFont();
        int tailLength = g2font.getSize() / 2;
        this.drawSquareBracket(x, x + tailLength, y1, y2, g2);
    }

    private void drawRightSquareBracket(int x, int y1, int y2, Graphics2D g2) {
        Font g2font = g2.getFont();
        int tailLength = g2font.getSize() / 2;
        this.drawSquareBracket(x, x - tailLength, y1, y2, g2);
    }

    private void drawSquareBracket(int x1, int x2, int y1, int y2, Graphics2D g2) {
        g2.drawLine(x1, y1, x1, y2);
        g2.drawLine(x1, y1, x2, y1);
        g2.drawLine(x1, y2, x2, y2);
    }

    private void drawLeftCurlyBracket(int x, int y1, int y2, Graphics2D g2) {
        Font g2font = g2.getFont();
        int d = (int)((double)g2font.getSize() * 0.618);
        g2.drawArc(x, y1 + d / 2, d, d, 90, 90);
        g2.drawArc(x - d, (y1 + y2) / 2 - d / 2, d, d, -90, 90);
        g2.drawArc(x - d, (y1 + y2) / 2 + d / 2, d, d, 0, 90);
        g2.drawArc(x, y2 - d / 2, d, d, 180, 90);
        g2.drawLine(x, y1 + d, x, (y1 + y2) / 2 + 1);
        g2.drawLine(x, y2, x, (y1 + y2) / 2 + d - 1);
    }

    private void drawRightCurlyBracket(int x, int y1, int y2, Graphics2D g2) {
        Font g2font = g2.getFont();
        int d = (int)((double)g2font.getSize() * 0.618);
        g2.drawArc(x - d, y1 + d / 2, d, d, 0, 90);
        g2.drawArc(x, (y1 + y2) / 2 - d / 2, d, d, 180, 90);
        g2.drawArc(x, (y1 + y2) / 2 + d / 2, d, d, 90, 90);
        g2.drawArc(x - d, y2 - d / 2, d, d, 270, 90);
        g2.drawLine(x, y1 + d, x, (y1 + y2) / 2 + 1);
        g2.drawLine(x, y2, x, (y1 + y2) / 2 + d - 1);
    }

    private void drawRefLine(int x1, int y1, int x2, int y2, int height, Graphics2D g2) {
        int x = x1 > x2 ? x1 + height : x2 + height;
        GeneralPath shape = new GeneralPath();
        Point p1 = new Point(x1, y1);
        Point p2 = new Point(x, y1);
        Point p3 = new Point(x, y2);
        Point p4 = new Point(x2, y2);
        shape.moveTo(p1.x, p1.y);
        shape.curveTo(p2.x, p2.y, p2.x, p2.y, p2.x, p2.y + (p3.y - p2.y) / 2);
        shape.curveTo(p3.x, p3.y, p3.x, p3.y, p4.x, p4.y);
        shape.moveTo(p3.x, p3.y);
        shape.closePath();
        g2.draw(shape);
    }

    @Override
    public void loadSentence() {
        AttributeValueMatrix headNode = (AttributeValueMatrix)this.treebank.get(this.sentenceNumber);
        this.RefList = headNode.getRefList();
        this.indexTable = new IdentityHashMap();
        this.nodesCount = headNode.countAllNodes();
        Collection<AttributeValueMatrix> nodesList = headNode.collectAllNodes();
        this.nodesArray = new AttributeValueMatrix[nodesList.size()];
        nodesList.toArray(this.nodesArray);
        int i = 0;
        while (i < this.nodesCount) {
            AttributeValueMatrix n = this.nodesArray[i];
            this.indexTable.put(n, i);
            ++i;
        }
        this.XLeftArray = new int[this.nodesCount];
        this.XBoarderLineArray = new int[this.nodesCount];
        this.XRightArray = new int[this.nodesCount];
        this.YUpArray = new int[this.nodesCount];
        this.YDownArray = new int[this.nodesCount];
        Arrays.fill(this.XLeftArray, -1);
        int Width = this.recursiveUpdateX(headNode, this.leftMargin) + this.rightMargin;
        int Height = this.recursiveUpdateY(headNode, this.topMargin) + this.bottomMargin;
        this.area = new Dimension(Width, Height);
    }

    public int recursiveUpdateX(AttributeValueMatrix avm, int lastX) {
        int currentX = lastX;
        AttributeValueMatrix OrigAVM = new AttributeValueMatrix();
        if (!avm.isContentOrPointer) {
            OrigAVM = avm;
            avm = AttributeValueMatrix.getRealContent(avm);
        }
        if (this.containedInRefList(OrigAVM)) {
            int i = this.indexTable.get(OrigAVM);
            this.XLeftArray[i] = currentX;
            this.XBoarderLineArray[i] = currentX;
            this.XRightArray[i] = this.XBoarderLineArray[i] + this.RefLineMargin;
            return this.XRightArray[i];
        }
        int i = this.indexTable.get(avm);
        Set<String> Keys = avm.getAllAttributeNames();
        this.XLeftArray[i] = currentX;
        int MaxAttributeNameLength = 0;
        for (String Key2 : Keys) {
            if (this.metrics.stringWidth(Key2) <= MaxAttributeNameLength) continue;
            MaxAttributeNameLength = this.metrics.stringWidth(Key2);
        }
        this.XBoarderLineArray[i] = this.XLeftArray[i] + MaxAttributeNameLength + this.XBoarderLineMargin;
        int MaxAttributeValuePos = currentX = this.XBoarderLineArray[i];
        int ValueEndPos = 0;
        for (String Key3 : Keys) {
            Value Val = avm.getAttributeValue(Key3);
            if (Val instanceof Atomic) {
                ValueEndPos = currentX + this.metrics.stringWidth(((Atomic)Val).getValue());
                if (ValueEndPos <= MaxAttributeValuePos) continue;
                MaxAttributeValuePos = ValueEndPos;
                continue;
            }
            if (Val instanceof SemanticForm) {
                String sfStr = "'";
                sfStr = String.valueOf(sfStr) + ((SemanticForm)Val).getPred();
                sfStr = String.valueOf(sfStr) + " <";
                String[] stringArray = ((SemanticForm)Val).getStringArgs();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String arg = stringArray[n2];
                    sfStr = String.valueOf(sfStr) + arg;
                    sfStr = String.valueOf(sfStr) + ", ";
                    ++n2;
                }
                if (sfStr.lastIndexOf(", ") != -1) {
                    sfStr = sfStr.substring(0, sfStr.lastIndexOf(", "));
                }
                if ((ValueEndPos = currentX + this.metrics.stringWidth(sfStr = String.valueOf(sfStr) + ">'")) <= MaxAttributeValuePos) continue;
                MaxAttributeValuePos = ValueEndPos;
                continue;
            }
            if (Val instanceof AttributeValueMatrix) {
                ValueEndPos = this.recursiveUpdateX((AttributeValueMatrix)Val, currentX);
                if (ValueEndPos <= MaxAttributeValuePos) continue;
                MaxAttributeValuePos = ValueEndPos;
                continue;
            }
            if (!(Val instanceof SetOfAttributeValueMatrix)) continue;
            for (AttributeValueMatrix e : ((SetOfAttributeValueMatrix)Val).getSet()) {
                ValueEndPos = this.recursiveUpdateX(e, currentX + this.CurlyBracketMargin) + this.CurlyBracketMargin;
                if (ValueEndPos <= MaxAttributeValuePos) continue;
                MaxAttributeValuePos = ValueEndPos;
            }
        }
        this.XRightArray[i] = MaxAttributeValuePos + this.XRightMargin;
        currentX = this.XRightArray[i];
        return currentX;
    }

    public int recursiveUpdateY(AttributeValueMatrix avm, int lastY) {
        int currentY = (int)((double)lastY + this.levelSize);
        if (!avm.isContentOrPointer) {
            avm = AttributeValueMatrix.getRealContent(avm);
        }
        int i = this.indexTable.get(avm);
        Set<String> Keys = avm.getAllAttributeNames();
        this.YUpArray[i] = currentY;
        for (String Key2 : Keys) {
            Value Val = avm.getAttributeValue(Key2);
            this.YFeatureTable.put(Val, currentY);
            if (this.containedInRefList(Val)) {
                int j = this.indexTable.get(Val);
                this.YUpArray[j] = (int)((double)currentY + this.levelSize);
                this.YDownArray[j] = this.YUpArray[j] + this.fontHight;
                currentY = (int)((double)currentY + ((double)this.fontHight + this.levelSize));
                continue;
            }
            if (Val instanceof Atomic || Val instanceof SemanticForm) {
                currentY = (int)((double)currentY + ((double)this.fontHight + 0.5 * this.levelSize));
                continue;
            }
            if (Val instanceof AttributeValueMatrix) {
                currentY = this.recursiveUpdateY((AttributeValueMatrix)Val, currentY);
                continue;
            }
            if (!(Val instanceof SetOfAttributeValueMatrix)) continue;
            currentY = (int)((double)currentY + this.levelSize);
            for (AttributeValueMatrix e : ((SetOfAttributeValueMatrix)Val).getSet()) {
                currentY = this.recursiveUpdateY(e, currentY);
            }
            currentY = (int)((double)currentY + this.levelSize);
        }
        this.YDownArray[i] = currentY;
        return currentY;
    }
}

