/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.features;

import com.aliasi.features.FeatureExtractorFilter;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.FeatureExtractor;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheFeatureExtractor<E>
extends FeatureExtractorFilter<E>
implements Serializable {
    static final long serialVersionUID = -3991123544605867490L;
    final Map<E, Map<String, ? extends Number>> mCache;

    public CacheFeatureExtractor(FeatureExtractor<? super E> extractor, Map<E, Map<String, ? extends Number>> cache) {
        super(extractor);
        this.mCache = cache;
    }

    public Map<E, Map<String, ? extends Number>> cache() {
        return this.mCache;
    }

    @Override
    public Map<String, ? extends Number> features(E in) {
        Map<String, ? extends Number> features = this.mCache.get(in);
        if (features == null) {
            features = this.baseExtractor().features(in);
            this.mCache.put(in, features);
        }
        return features;
    }

    Object writeReplace() {
        return new Serializer(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Serializer<F>
    extends AbstractExternalizable {
        static final long serialVersionUID = 4597111698841666424L;
        final CacheFeatureExtractor<F> mExtractor;

        public Serializer(CacheFeatureExtractor<F> extractor) {
            this.mExtractor = extractor;
        }

        public Serializer() {
            this(null);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.mExtractor.mExtractor);
            out.writeObject(this.mExtractor.mCache);
        }

        @Override
        public Object read(ObjectInput in) throws ClassNotFoundException, IOException {
            FeatureExtractor extractor = (FeatureExtractor)in.readObject();
            Map cache = (Map)in.readObject();
            return new CacheFeatureExtractor(extractor, cache);
        }
    }
}

