/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.AbstractTreeExtractor;
import edu.stanford.nlp.parser.lexparser.DependencyGrammar;
import edu.stanford.nlp.parser.lexparser.IntDependency;
import edu.stanford.nlp.parser.lexparser.MLEDependencyGrammar;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.Index;
import java.util.List;

public class MLEDependencyGrammarExtractor
extends AbstractTreeExtractor<DependencyGrammar> {
    protected final Index<String> wordIndex;
    protected final Index<String> tagIndex;
    protected ClassicCounter<IntDependency> dependencyCounter = new ClassicCounter();
    protected TreebankLangParserParams tlpParams;
    protected boolean directional;
    protected boolean useDistance;
    protected boolean useCoarseDistance;
    protected final boolean basicCategoryTagsInDependencyGrammar;

    public MLEDependencyGrammarExtractor(Options op, Index<String> wordIndex, Index<String> tagIndex) {
        super(op);
        this.wordIndex = wordIndex;
        this.tagIndex = tagIndex;
        this.tlpParams = op.tlpParams;
        this.directional = op.directional;
        this.useDistance = op.distance;
        this.useCoarseDistance = op.coarseDistance;
        this.basicCategoryTagsInDependencyGrammar = op.trainOptions.basicCategoryTagsInDependencyGrammar;
    }

    @Override
    protected void tallyRoot(Tree lt, double weight) {
        List<IntDependency> deps = MLEDependencyGrammar.treeToDependencyList(lt, this.wordIndex, this.tagIndex);
        for (IntDependency dependency : deps) {
            this.dependencyCounter.incrementCount(dependency, weight);
        }
    }

    @Override
    public DependencyGrammar formResult() {
        this.wordIndex.indexOf("UNK", true);
        MLEDependencyGrammar dg = new MLEDependencyGrammar(this.tlpParams, this.directional, this.useDistance, this.useCoarseDistance, this.basicCategoryTagsInDependencyGrammar, this.op, this.wordIndex, this.tagIndex);
        for (IntDependency dependency : this.dependencyCounter.keySet()) {
            dg.addRule(dependency, this.dependencyCounter.getCount(dependency));
        }
        return dg;
    }
}

