theory question_72_9
imports Main

begin

typedecl entity
typedecl event

consts
  Friction :: "entity ⇒ bool"
  Vehicle :: "entity ⇒ bool"
  Surfaces :: "entity ⇒ bool"
  Touching :: "entity ⇒ entity ⇒ entity ⇒ bool"
  Wagon :: "entity ⇒ bool"
  Stop :: "event ⇒ bool"
  Cause :: "event ⇒ event ⇒ bool"
  No_event :: "event ⇒ bool"

(* Explanation: "No event" means nothing happens. *)
axiomatization where
  explanation_1: "No_event e"

theorem hypothesis:
  assumes asm: "No_event x"
  shows "∃x y e1 e2. Wagon x  ∧ Friction y  ∧ Acting e1  ∧ Agent e1  y  ∧ Patient e1  x  ∧  Stop e2  ∧ Agent e2  x  ∧ Cause e1  e2  "
proof -
  from asm have "No_event x" by simp
  then have "Wagon x" by simp
  then have "Friction y" for y using explanation_5 by blast
  then have "Acting e1" for e1 using explanation_6 by blast
  then have "Agent e1 y" for y using explanation_6 by blast
  then have "Patient e1 x" for x using explanation_6 by blast
  then have "Stop e2" for e2 using explanation_7 by blast
  then have "Agent e2 x" for x using explanation_7 by blast
  then have "Cause e1 e2" using explanation_7 by blast
  then show ?thesis using asm `Friction y` `Wagon x` by blast
qed

end
