theory question_23_4
imports Main

begin

typedecl entity
typedecl event

consts
  Hurricane :: "entity ⇒ bool"
  Tornado :: "entity ⇒ bool"
  HighWinds :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation 1: High wind speeds are a shared characteristic of both hurricanes and tornadoes. *)
axiomatization where
  explanation_1: "∀x. (Hurricane x ∨ Tornado x) ⟶ (∃e. HighWinds e ∧ Agent e x)"

(* Explanation 2: High wind speeds are a direct characteristic of both hurricanes and tornadoes. *)
axiomatization where
  explanation_2: "∀x. (Hurricane x ∨ Tornado x) ⟶ (∃e. HighWinds e ∧ Patient e x)"

theorem hypothesis:
  assumes asm: "Hurricane e' ∨ Tornado e'"
  (* Hypothesis: Both hurricanes and tornadoes always have high winds. *)
  shows "HighWinds e'"
proof -
  from asm have "Hurricane e' ∨ Tornado e'" by simp
  then have "∃e. HighWinds e ∧ Agent e e'" using explanation_1 by blast
  then have "HighWinds e'" using explanation_2 by blast
  then show ?thesis by simp
qed

end
