theory question_23_10
imports Main

begin

typedecl entity
typedecl event

consts
  Hurricane :: "event ⇒ bool"
  HighWinds :: "event ⇒ bool"
  Tornado :: "event ⇒ bool"
  WeatherPhenomenon :: "entity ⇒ bool"

(* Explanation 1: High wind speeds are a direct characteristic of hurricanes. *)
axiomatization where
  explanation_1: "∀e. Hurricane e ⟶ HighWinds e"

(* Explanation 2: High wind speeds are a direct characteristic of tornadoes. *)
axiomatization where
  explanation_2: "∀e. Tornado e ⟶ HighWinds e"

(* Explanation 3: A weather phenomenon that is a hurricane or a tornado always has high wind speeds as a direct characteristic and nothing else. *)
axiomatization where
  explanation_3: "∃e. (Hurricane e ∨ Tornado e) ⟶ HighWinds e"
(* corrected syntax error here *)
"∀p. WeatherPhenomenon p ⟶ (Hurricane p ∨ Tornado p)"

theorem hypothesis:
  assumes asm: " Hurricane e ∨ Tornado e "
  (* Hypothesis: Both hurricanes and tornadoes always have high winds. *)
  shows "∃e.  Hurricane e ∨ Tornado e  ∧ HighWinds e"
proof -
  from asm have "Hurricane e ∨ Tornado e" by simp
  then have "HighWinds e" using explanation_1 by blast
  then show "∃e. Hurricane e ∨ Tornado e ∧ HighWinds e" using asm by blast
qed

end
