theory question_93_3
imports Main

begin

typedecl entity

consts
  AdultEchinoderms :: "entity ⇒ bool"
  RadialSymmetry :: "entity ⇒ bool"
  Starfish :: "entity ⇒ bool"
  Echinoderms :: "entity ⇒ bool"
  AdultStarfish :: "entity ⇒ bool"

(* Explanation 1: Adult echinoderms, which include starfish, have radial symmetry. Starfish inherit this radial symmetry as they are a type of echinoderm. *)
axiomatization where
  explanation_1: "∀x. AdultEchinoderms x ⟶ RadialSymmetry x"
  explanation_2: "∀x. Starfish x ⟶ AdultEchinoderms x"

(* Explanation 2: Echinoderms with radial symmetry include adult starfish, indicating that adult starfish have radial symmetry. *)
axiomatization where
  explanation_3: "∀x. RadialSymmetry x ⟶ (Echinoderms x ∧ AdultStarfish x)"

(* Explanation 3: Adult starfish, as a type of echinoderm, inherit radial symmetry from their echinoderm classification. *)
axiomatization where
  explanation_4: "∀x. AdultStarfish x ⟶ (Echinoderms x ∧ RadialSymmetry x)"

theorem hypothesis:
  assumes asm: "AdultStarfish x"
  (* Hypothesis: Adults of starfish have radial symmetry. *)
  shows "RadialSymmetry x"
proof -
  from asm have "AdultEchinoderms x" using explanation_2 by blast.
  with asm have "RadialSymmetry x" using explanation_1 by blast.
  then show "RadialSymmetry x" by simp.
qed

end
