theory question_86_6

imports Main

begin

typedecl entity
typedecl event

consts
  Snow :: "entity ⇒ bool"
  Water :: "entity ⇒ bool"
  BelowFreezing :: "event ⇒ bool"
  SolidState :: "entity ⇒ bool"
  Appears :: "entity ⇒ event ⇒ bool"

(* Explanation 1: Snow is a form of water that is in the solid state at temperatures below the freezing point. *)
axiomatization where
  explanation_1: "∀x. Snow x ∧ Water x ⟶ (∃e. BelowFreezing e ∧ Appears x e ∧ SolidState x)"

theorem hypothesis:
  assumes asm: "Snow x ∧ Water x ∧ BelowFreezing e"
  (* Hypothesis: Snow is the form of water that appears when the temperature is below freezing. *)
  shows "Appears x e"
proof -
  from asm have "Snow x ∧ Water x" by simp
  then obtain e' where e': "BelowFreezing e' ∧ Appears x e' ∧ SolidState x" using explanation_1 by blast
  then have "Appears x e'" by simp
  from asm have "BelowFreezing e" by simp
  then show ?thesis using e' by blast
qed

end
