theory question_23_0
imports Main
begin

typedecl entity
typedecl event

consts
  Hurricane :: "entity ⇒ bool"
  Tornadoes :: "entity ⇒ bool"
  HighWindSpeeds :: "event ⇒ bool"
  Has :: "entity ⇒ event ⇒ bool"
  HighWinds :: "event ⇒ bool"

(* Explanation 1: a hurricane has high wind speeds. *)
axiomatization where
  explanation_1: "∀x. Hurricane x ⟹ (∃e. HighWindSpeeds e ∧ Has x e)"

(* Explanation 2: a tornado has high wind speeds. *)
axiomatization where
  explanation_2: "∀x. Tornadoes x ⟹ (∃e. HighWindSpeeds e ∧ Has x e)"

theorem hypothesis:
  assumes asm: "Hurricane x ∨ Tornadoes x"
  (* Hypothesis: Both hurricanes and tornadoes always have high winds. *)
  shows "∃e.  Hurricane x ∨ Tornadoes x  ⟹ HighWinds e ∧ Has x e"
proof -
  assume asm: "Hurricane x ∨ Tornadoes x"
  {
    assume "Hurricane x"
    then obtain e where "HighWindSpeeds e ∧ Has x e" using explanation_1 by blast
    then show "∃e. HighWinds e ∧ Has x e" using HighWindSpeeds_def by blast
  }
  moreover {
    assume "Tornadoes x"
    then obtain e where "HighWindSpeeds e ∧ Has x e" using explanation_2 by blast
    then show "∃e. HighWinds e ∧ Has x e" using HighWindSpeeds_def by blast
  }
  ultimately show "∃e. HighWinds e ∧ Has x e" using asm by blast
qed

end
