theory question_66_1

imports Main

begin
typedecl entity
typedecl event

consts
  Bartender :: "entity ⇒ bool"
  Person :: "entity ⇒ bool"
  DressedInBlack :: "entity ⇒ bool"
  InBlack :: "entity ⇒ bool"
  Male :: "entity ⇒ bool"
  Drink :: "entity ⇒ bool"
  MartiniGlass :: "entity ⇒ bool"
  Making :: "event ⇒ bool"
  SleevesRolledUp :: "entity ⇒ bool"
  ElbowHeight :: "entity ⇒ bool"
  In :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: A bartender is a person. *)
axiomatization where
  explanation_1: "∀x. Bartender x ⟶ Person x"

(* Explanation 2: If a person is dressed in black, then the person is in black. *)
axiomatization where
  explanation_2: "∀x. DressedInBlack x ⟶ InBlack x"

theorem hypothesis:
  (* Premise: A male bartender dressed in all black with his sleeves rolled up to elbow height making a drink in a martini glass. *)
  assumes asm: "Male x ∧ Bartender x ∧ DressedInBlack x ∧ SleevesRolledUp x ∧ ElbowHeight x ∧ Drink y ∧ MartiniGlass z ∧ Making e ∧ Agent e x ∧ Patient e y ∧ In y z"
  (* Hypothesis: A person in black *)
  shows "∃x. Person x ∧ InBlack x"
proof -
  {
    assume "Male x ∧ Bartender x ∧ DressedInBlack x ∧ SleevesRolledUp x ∧ ElbowHeight x ∧ Drink y ∧ MartiniGlass z ∧ Making e ∧ Agent e x ∧ Patient e y ∧ In y z"
    hence "Bartender x" by blast
    hence "Person x" using explanation_1 by blast
    hence "InBlack x" using explanation_2 by blast
    with "Person x" show "∃x. Person x ∧ InBlack x" by blast
  }
qed

end
