theory question_80_7

imports Main

begin

typedecl entity
typedecl event

consts
  Copper :: "entity ⇒ bool"
  ConductsElectricity :: "entity ⇒ bool"

(* Explanation 1: Copper is a material that conducts electricity. *)
axiomatization where
  explanation_1: "∃x. Copper x ∧ ConductsElectricity x"

theorem hypothesis:
  (* Premise: Some materials are electrical conductors. *)
  assumes asm: "Materials x ∧ ElectricalConductors x"
  (* Hypothesis: Copper is the material that conducts electricity. *)
  shows "∃x. Copper x ∧ ConductsElectricity x"
proof -
  from asm have "Materials x ∧ ElectricalConductors x" by simp
  then obtain e1 where e1: "Copper x ∧ ConductsElectricity x" using explanation_1 by blast
  show ?thesis using e1 by simp
qed

end
