theory question_90_8

imports Main

begin

typedecl entity
typedecl event

consts
 Man :: "entity ⇒ bool"
 Walking :: "event ⇒ bool"
 Running :: "event ⇒ bool"
 Suddenly :: "event ⇒ bool"
 Seen :: "event ⇒ entity ⇒ bool"
 Scary :: "entity ⇒ bool"

(* Explanation 1: If a man is walking down the street and suddenly starts running, it can be assumed that he has seen something scary. *)
axiomatization where
 explanation_1: "∀x y e. Man x ∧ Walking y ∧ Suddenly e ∧ Running e ∧ Seen e Scary ⟶ Assumed Scary"

theorem hypothesis:
 (* Premise: A man is walking down the street and suddenly starts running. *)
 assumes asm: "Man x ∧ Walking y ∧ Suddenly e ∧ Running e"
 (* Hypothesis: The man has seen something scary. *)
 shows "∃e. Seen e Scary"
proof -
 from asm have "Man x" by blast
 from this have "Walking y" using explanation_1 by blast
 from asm have "Suddenly e" by blast
 from this have "Running e" using explanation_1 by blast
 from asm have "Seen e Scary" using explanation_1 by blast
 show ?thesis using `Man x` `Walking y` `Suddenly e` `Running e` `Seen e Scary` by blast
qed

end
