theory question_88_5

imports Main

begin

typedecl entity
typedecl event

consts
 Gymnast :: "entity ⇒ bool"
 Gymnastics :: "entity ⇒ bool"
 DisplayOfSkills :: "event ⇒ bool"
 Agent :: "event ⇒ entity ⇒ bool"
 Patient :: "event ⇒ entity ⇒ bool"
 Flip :: "event ⇒ bool"
 Turns :: "event ⇒ bool"
 BalancingActs :: "event ⇒ bool"

(* Explanation 1: The woman was sitting under the tree playing guitar. *)
axiomatization where
 explanation_1: "∀x y e. Gymnast x ∧ Gymnastics y ∧ DisplayOfSkills e ∧ Agent e x ∧ Patient e y ∧ Flip e ∧ Turns e ∧ BalancingActs e"

theorem hypothesis:
 (* Premise: Gymnast does a flip on blue flooring. *)
 assumes asm: "Gymnast x  ∧ BlueFlooring y  ∧ Flip e  ∧ Agent e  x  ∧ Patient e  y  ∧ On e  y "
 (* Hypothesis: A gymnast displays their skills with a flip. *)
 shows "∃x y e. Gymnast x  ∧ Skills y  ∧ Flip e  ∧ Agent e  x  ∧ Patient e  y "
proof -
 from asm have "Gymnast x" by blast
 from this have "Skills y" using explanation_1 by blast
 from asm have "Flip e" by blast
 from this have "Agent e x" and "Patient e y" using explanation_2 by blast
 from asm have "On e y" by blast
 show ?thesis using `Gymnast x` `Skills y` `Flip e` `Agent e x` `Patient e y` `On e y` by blast
qed

end
