theory question_85_2

imports Main

begin

typedecl entity
typedecl event

consts
 FlowerSeller :: "entity ⇒ bool"
 Sidewalk :: "entity ⇒ bool"
 FlowerCart :: "entity ⇒ bool"
 Vendor :: "entity ⇒ bool"
 Selling :: "event ⇒ entity ⇒ bool"
 Agent :: "event ⇒ entity ⇒ bool"
 Patient :: "event ⇒ entity ⇒ bool"
 InFrontOf :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: A vendor exists. *)
axiomatization where
explanation_1: "∀x. Vendor x"

(* Explanation 2: Vendor is a seller of flowers. *)
axiomatization where
explanation_2: "∀x y. Vendor x ∧ Flowers y ∧ Selling x y"

theorem hypothesis:
 (* Premise: Sidewalk flower cart vendor. *)
 assumes asm: "Sidewalk x  ∧ FlowerCart y  ∧ Vendor z  ∧ Vending e  ∧ Agent e  z  ∧ Patient e  x  ∧ InFrontOf z  y "
 (* Hypothesis: Flower seller on sidewalk. *)
 shows "∃x y e. FlowerSeller x  ∧ Sidewalk y  ∧ Selling e  ∧ Agent e  x  ∧ Patient e  y "
proof -
 from asm have "Vendor x" by blast
 then have "FlowerSeller x" using explanation_1 by blast
 then have "Sidewalk y" using explanation_2 by blast
 then show ?thesis using `FlowerSeller x` `Sidewalk y` by blast
qed

end
