theory question_81_0

imports Main

begin

typedecl entity
typedecl event
consts
  Person :: "entity ⇒ bool"
  Bike :: "entity ⇒ bool"
  Bicycle :: "entity ⇒ bool"
  Outside :: "entity ⇒ bool"
  Helmet :: "entity ⇒ bool"
  Jumping :: "event ⇒ bool"
  Soaring :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  InFrontOf :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: Bike is the short word for bicycle, and the person is outside if the person is soaring over the ground. *)
axiomatization where
  explanation_1: "∀x. Bike x ⟶ Bicycle x ∧ Outside x"

theorem hypothesis:
  (* Premise: A person on a bicycle wears a helmet and jumps, soaring over the ground in front of a skyline and lake. *)
  assumes asm: "Person x  ∧ Bicycle y  ∧ Helmet z  ∧ Jumping e1  ∧ Soaring e2  ∧ Agent e1  x  ∧ Agent e2  x  ∧ Patient e1  y  ∧ InFrontOf x  z "
  (* Hypothesis: A person outside with a bike. *)
  shows "∃x y e. Person x  ∧ Bike y  ∧ Riding e  ∧ Agent e  x  ∧ Patient e  y "
proof -
  from asm have "Person x" using explanation_1 by blast
  from asm have "Bicycle y" using explanation_1 by blast
  from asm have "Outside x" using explanation_1 by blast
  show ?thesis using `Person x` `Bicycle y` `Outside x` by blast
qed

end
