theory question_80_10

imports Main

begin

typedecl entity
typedecl event

consts
  Copper :: "entity ⇒ bool"
  Material :: "entity ⇒ bool"
  ElectricalConductor :: "entity ⇒ bool"
  Conduct :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Electricity :: "event ⇒ bool"

(* Explanation 1: Copper is a material and it is an electrical conductor. *)
axiomatization where
  explanation_1: "∀x. Copper x ⟶ Material x ∧ ElectricalConductor x"

(* Explanation 2: Copper, as an electrical conductor, can conduct electricity. *)
axiomatization where
  explanation_2: "∀x e. Copper x ∧ ElectricalConductor x ∧ Conduct e ∧ Agent e x ⟶ Electricity e"  

theorem hypothesis:
  (* Premise: Some materials are electrical conductors. *)
  assumes asm: "Material x ∧ ElectricalConductor x"
  (* Hypothesis: Copper is the material that conducts electricity. *)
  shows "∃x e. Copper x ∧ Conduct e ∧ Agent e x ∧ Electricity e"
proof -
  from asm have "Copper x" using explanation_1 by blast
  then obtain e where e: "Conduct e ∧ Agent e x ∧ Electricity e" using explanation_2 by blast
  show ?thesis using asm `Copper x` e by blast
qed

end
