theory question_65_10

imports Main

begin

typedecl entity
typedecl event

consts
  Electricity :: "entity ⇒ bool"
  LightBulb :: "entity ⇒ bool"
  Flows :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  TurnOn :: "event ⇒ bool"
  ComesOn :: "event ⇒ bool"
  SimpleSeriesCircuit :: "entity ⇒ bool"
  Switch :: "entity ⇒ bool"
  Includes :: "event ⇒ bool"
  Closed :: "event ⇒ bool"
  Complete :: "event ⇒ bool"
  Circuit :: "entity ⇒ bool"
  Starts :: "event ⇒ bool"
  Flowing :: "event ⇒ bool"

(* Explanation 1: When electricity flows to a light bulb, the light bulb will turn on; come on. *)
axiomatization where
  explanation_1: "∀x y e1 e2. Electricity x ∧ LightBulb y ∧ Flows e1 ∧ Agent e1 x ∧ Patient e1 y ⟶ TurnOn e2 ∧ Agent e2 y ∧ ComesOn e2 ∧ Agent e2 y"

(* Explanation 2: A simple series circuit includes a light bulb and a switch. *)
axiomatization where
  explanation_2: "∀x y z e. SimpleSeriesCircuit x ∧ LightBulb y ∧ Switch z ∧ Includes e ∧ Agent e x ∧ Patient e y ∧ Patient e z"

(* Explanation 3: When the switch in a simple series circuit is closed, the circuit is complete. *)
axiomatization where
  explanation_3: "∀x y e1 e2. Switch x ∧ SimpleSeriesCircuit y ∧ Closed e1 ∧ Agent e1 x ⟶ Complete e2 ∧ Agent e2 y"

(* Explanation 4: When the circuit is complete, electricity starts flowing. *)
axiomatization where
  explanation_4: "∀x y e1 e2. Circuit x ∧ Electricity y ∧ Complete e1 ∧ Agent e1 x ⟶ Starts e2 ∧ Agent e2 y ∧ Flowing e2"

(* Explanation 5: The electricity in a simple series circuit flows from the switch to the light bulb. *)
axiomatization where
  explanation_5: "∀x y z w e. Electricity x ∧ SimpleSeriesCircuit y ∧ Switch z ∧ LightBulb w ∧ Flows e ∧ Agent e x ∧ Patient e z ∧ Patient e w"

theorem hypothesis:
  (* Premise: when the switch in a simple series circuit is closed *)
  assumes asm: "Switch x ∧ SimpleSeriesCircuit y ∧ Closed e ∧ Agent e x"
  (* Hypothesis: When electricity is flowing to the light bulb, the light comes on. *)
  shows "∃x y e1 e2. Electricity x ∧ LightBulb y ∧ Flowing e1 ∧ Agent e1 x ∧ Patient e1 y ∧ ComesOn e2 ∧ Agent e2 y"
proof -
  from asm have "Complete e ∧ Agent e y" using explanation_3 by blast
  then obtain e1 where e1: "Starts e1 ∧ Agent e1 y ∧ Flowing e1" using explanation_4 by blast
  then obtain e2 where e2: "Electricity x ∧ LightBulb y ∧ Flowing e1 ∧ Agent e1 x ∧ Patient e1 y" using explanation_5 by blast
  then have "ComesOn e2 ∧ Agent e2 y" using explanation_1 by blast
  then show ?thesis using asm e1 e2 by blast
qed

end
