theory question_65_0

imports Main

begin

typedecl entity
typedecl event

consts
  Electricity :: "entity ⇒ bool"
  LightBulb :: "entity ⇒ bool"
  Flows :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  TurnOn :: "event ⇒ bool"
  ComesOn :: "event ⇒ bool"
  Switch :: "entity ⇒ bool"
  SimpleSeriesCircuit :: "entity ⇒ bool"
  Closed :: "event ⇒ bool"
  Flow :: "event ⇒ bool"

(* Explanation 1: when electricity flows to a light bulb , the light bulb will turn on; come on. *)
axiomatization where
  explanation_1: "∀x y e1 e2 e3. Electricity x ∧ LightBulb y ∧ Flows e1 ∧ Agent e1 x ∧ Patient e1 y ⟶ (TurnOn e2 ∧ Agent e2 y) ∨ (ComesOn e3 ∧ Agent e3 y)"

(* Explanation 2: when a switch in a simple series circuit is closed , electricity will flow through the circuit. *)
axiomatization where
  explanation_2: "∀x y z e1 e2. Switch x ∧ SimpleSeriesCircuit y ∧ Electricity z ∧ Closed e1 ∧ Agent e1 x ∧ Patient e1 y ⟶ Flow e2 ∧ Agent e2 z ∧ Patient e2 y"  

theorem hypothesis:
  (* Premise: when the switch in a simple series circuit is closed *)
  assumes asm: "Switch x ∧ SimpleSeriesCircuit y ∧ Closed e ∧ Agent e x ∧ Patient e y"
  (* Hypothesis: When electricity is flowing to the light bulb, the light comes on. *)
  shows "∃x y e1 e2. Electricity x ∧ LightBulb y ∧ Flow e1 ∧ Agent e1 x ∧ Patient e1 y ∧ ComesOn e2 ∧ Agent e2 y"
proof -
  from asm obtain e2 where e2: "Flow e2 ∧ Agent e2 x ∧ Patient e2 y" using explanation_2 by blast
  then have "Electricity x" by simp
  then obtain e1 where e1: "TurnOn e1 ∧ Agent e1 y ∨ ComesOn e1 ∧ Agent e1 y" using explanation_1 by blast
  then have "ComesOn e1 ∧ Agent e1 y" by simp
  show ?thesis using asm e2 `Electricity x` `ComesOn e1 ∧ Agent e1 y` by blast
qed

end
