theory question_94_10
imports Main

begin
typedecl entity
typedecl event

consts
  LittleBoy :: "entity ⇒ bool"
  Boy :: "entity ⇒ bool"
  Person :: "entity ⇒ bool"
  Bathroom :: "entity ⇒ bool"
  Building :: "entity ⇒ bool"
  In :: "entity ⇒ entity ⇒ bool"
  Inside :: "entity ⇒ entity ⇒ bool"
  Bathrobe :: "entity ⇒ bool"
  Bench :: "entity ⇒ bool"
  Shower :: "entity ⇒ bool"
  Sits :: "event ⇒ entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Near :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: A little boy is a boy. A boy is a person. *)
axiomatization where
  explanation_1: "∀x. LittleBoy x ⟶ Boy x" and
  explanation_2: "∀x. Boy x ⟶ Person x"

(* Explanation 2: A bathroom is inside a building. If a boy is in a bathroom, then the bathroom is inside that specific building and the boy is inside that specific building. *)
axiomatization where
  explanation_3: "∀x y z. Bathroom x ∧ Building y ∧ Boy z ∧ In z x ⟶ Inside x y ∧ Inside z y"

theorem hypothesis:
  (* Premise: A little boy in a bathrobe sits on a bench near the shower in a bathroom. *)
  assumes asm: "LittleBoy x ∧ Bathrobe x ∧ Bench y ∧ Shower z ∧ Bathroom z ∧ Sits e x ∧ Agent e x ∧ Patient e y ∧ Near y z"
  (* Hypothesis: The boy is inside of the building. *)
  shows "∃x y. Boy x ∧ Building y ∧ Inside x y"
proof -
  from asm have "LittleBoy x" by blast
  then have "Boy x" using explanation_1 by blast
  from asm have "Bathroom z" by blast
  then have "Building y ∧ Inside x y" using `Boy x` explanation_3 by blast
  then show ?thesis using `Boy x` by blast
qed

end
