theory question_81_4

imports Main

begin

typedecl entity
typedecl event

consts
  ExternalMigration :: "event ⇒ bool"
  BottleneckEffect :: "entity ⇒ bool"
  Trigger :: "event ⇒ bool"
  Triggered :: "event ⇒ bool"
  
(* Explanation 1: External migration can trigger the bottleneck effect. *)
axiomatization where
  explanation_1: "∀e x. ExternalMigration e ∧ BottleneckEffect x ⟶ Trigger e"

(* Explanation 2: The bottleneck effect can be triggered by external migration. *)
axiomatization where
  explanation_2: "∀e x. BottleneckEffect x ∧ ExternalMigration e ⟶ Triggered e"

theorem hypothesis:
  assumes asm: "BottleneckEffect x ∧ ExternalMigration e"
  (* Hypothesis: Bottleneck effect can occur with external migration. *)
  shows "Occur e"
proof -
  from asm have "BottleneckEffect x ∧ ExternalMigration e" by simp
  then have "Trigger e" using explanation_1 by blast
  then show ?thesis using `Trigger e` by blast
qed

end
