theory question_30_2

imports Main

begin
typedecl entity
typedecl event

consts
  Human :: "entity ⇒ bool"
  Man :: "entity ⇒ bool"
  Skateboard :: "entity ⇒ bool"
  Doing :: "event ⇒ bool"
  Tricks :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Location :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Doing tricks on a skateboard by a man implies that the man is a human. *)
axiomatization where
  explanation_1: "∀x y e. Man x ∧ Skateboard y ∧ Doing e ∧ Tricks e ∧ Agent e x ∧ Location e y ⟶ Human x"

theorem hypothesis:
  (* Premise: A man is doing tricks on a skateboard. *)
  assumes asm: "Man x ∧ Skateboard y ∧ Doing e ∧ Tricks e ∧ Agent e x ∧ Location e y"
  (* Hypothesis: A human doing tricks. *)
  shows "∃x e. Human x ∧ Doing e ∧ Tricks e ∧ Agent e x"
proof -
  from asm have "Man x ∧ Skateboard y ∧ Doing e ∧ Tricks e ∧ Agent e x" by blast
  then have "Human x" using explanation_1 by blast
  then show ?thesis using `Human x` by blast
qed

end
