from django.shortcuts import render
from evalAdv.models import ExpectationItem, SessionItem, DistractorItem, AnswerItem, CombinedSessionItem
from django.urls import reverse
import uuid
import random
import re


# Create your views here.


from django.http import HttpResponse, HttpResponseRedirect


# first page to hit

def index(request):


    # initialize participant id and session id

    participant_id = str(uuid.uuid4())
    session_id = 1
    request.session["participant_id"] = participant_id
    request.session["session_id"] = session_id
    request.session["allItemIds"] = [x.item_id for x in ExpectationItem.objects.all()]
    request.session["allDistIds"] = [x.question_id for x in DistractorItem.objects.all()]
    
    # render introduction
    return render(request, 'evalAdv/index.html')


def intro(request):


    if "unit" in request.POST.keys() and "prolificid" in request.POST.keys():

        # validate prolific id

        #request.session["prolificid"] = request.POST["prolificid"]
        this_prolific_id = request.POST["prolificid"]
        this_prolific_id = this_prolific_id.strip()


        
        match_bool = re.match("^[a-f\d]{24}$", this_prolific_id)

        # when they enter wrong id, loop until they get it right...
        if not match_bool and this_prolific_id != "":
            return HttpResponseRedirect(reverse('evalAdv:invalid'))


        request.session["prolificid"] = this_prolific_id

        request.session["unit"] = request.POST["unit"] # "metric" or "us"

        if request.session["unit"] == "metric":
            return render(request, 'evalAdv/introduction_de.html')
        elif request.session["unit"] == "us":
            return render(request, 'evalAdv/introduction.html')
        else:
            return render(request, 'evalAdv/introduction.html')


def invalid(request):
    return render(request, 'evalAdv/invalid.html')

# main loop, presenting the study items to the 
# participants, randomly chosing items from
# the table with ExpectationItems


def prepare(request):

    items_bool = True if len(request.session["allItemIds"]) > 0 else False
    dist_bool = True if len(request.session["allDistIds"]) > 0 else False

    if items_bool and dist_bool:
        this_type = random.choice(["item", "dist"])
        request.session["this_type"] = this_type
    elif items_bool and not dist_bool:
        this_type = "item"
        request.session["this_type"] = this_type
    elif dist_bool and not items_bool:
        this_type = "dist"
        request.session["this_type"] = this_type
    else:
        # if no items are left, return outro / payment code
        return HttpResponseRedirect(reverse('evalAdv:combined_session'))

    

    return HttpResponseRedirect(reverse('evalAdv:sessions'))
 

def sessions(request):
    
    # determine session or distractor question
    

    
    # # if still items are left to be interpreted
    
    this_type = request.session["this_type"]


    
    if this_type == "item":

        # random choice

        allItemIds = request.session["allItemIds"]
        
        this_item =  random.choice(allItemIds)
        allItemIds.remove(this_item) #list(filter(lambda x: x != this_item, allItemIds))
        request.session["allItemIds"] = allItemIds
        request.session["prev_s_item"] = this_item
        request.session["prev_item_type"] = "item"
        # retrieve item from database

        first = ExpectationItem.objects.get(pk=this_item)

        # prepare html fields
        
        if request.session["unit"] == "metric":
            task_string = first.task_string
            expectation_string = first.expression
            min_val = first.min_val
            max_val = first.max_val
            lower_def = first.lower_def
            upper_def = first.upper_def
            unit = first.physical_unit
            stepsize = first.stepsize
        elif request.session["unit"] == "us":
            task_string = first.task_string_us
            expectation_string = first.expression_us
            min_val = first.min_val_us
            max_val = first.max_val_us
            lower_def = first.lower_def
            upper_def = first.upper_def
            unit = first.physical_unit_us
            stepsize = first.stepsize

        context={"min_val":min_val, 
        "max_val":max_val, 
        "task_string": task_string,                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             
        "expectation_string":expectation_string,
        "lower_def":lower_def,
        "upper_def": upper_def,
        "unit": unit,
        "type": this_type,
        "stepsize": stepsize,
        }
        
        # render item

        return render(request, 'evalAdv/session.html', context=context)

    elif this_type == "dist":
        allDistIds = request.session["allDistIds"]

        this_item =  random.choice(allDistIds)
        allDistIds.remove(this_item) #list(filter(lambda x: x != this_item, allItemIds))
        request.session["allDistIds"] = allDistIds
        request.session["prev_s_dist"] = this_item
        request.session["prev_item_type"] = "dist"

        # retrieve item from database

        first = DistractorItem.objects.get(pk=this_item)

        # prepare html fields

        if request.session["unit"] == "metric":
            task_string = first.task_string
            question_text = first.question_text
            option_1 = first.option_1
            option_2 = first.option_2
            option_3 = first.option_3
        elif request.session["unit"] == "us":
            task_string = first.task_string_us
            question_text = first.question_text_us
            option_1 = first.option_1_us
            option_2 = first.option_2_us
            option_3 = first.option_3_us




        context={
            "task_string":task_string,
            "question_text":question_text,
            "option_1": option_1,
            "option_2": option_2,
            "option_3": option_3,
            "type": this_type,
            
        }
        
        # render item

        return render(request, 'evalAdv/session.html', context=context)


def get_user_input(request):

    item_type = request.session["prev_item_type"]

    if item_type == "item":

        if request.method == 'POST' and "left_slider" in request.POST.keys() and "right_slider" in request.POST.keys():
            lowerlim = request.POST["left_slider"]
            upperlim = request.POST["right_slider"]   


            request.session["prev_ans"] = str(lowerlim) + "_" + str(upperlim) 
            # get current expectationItem object from db
            last_item = request.session["prev_s_item"]
            last = ExpectationItem.objects.get(pk=last_item)

            # get participant id from cookie
            pid = request.session["participant_id"]

            # get session id from cookie
            sid = request.session["session_id"]

            unit_type = request.session["unit"]

            prolificid = request.session["prolificid"]
            
            thisSession = SessionItem(item_id=last, prolific_id=prolificid, unit_type=unit_type, session_id=sid, participant_id=pid, lower_limes=lowerlim, upper_limes=upperlim)
            thisSession.save()  
            request.session["session_id"] += 1
                
    elif item_type == "dist":

        if request.method == "POST" and "dist" in request.POST.keys():
            this_choice = request.POST["dist"]
            last_item = request.session["prev_s_dist"]
            last = DistractorItem(pk=last_item)
            request.session["prev_ans"] = this_choice

            pid = request.session["participant_id"]
            
            unit_type = request.session["unit"]
            prolificid = request.session["prolificid"]
       
            thisAnswer = AnswerItem(question_id=last, prolific_id=prolificid, unit_type=unit_type, participant_id=pid, answer_string=this_choice)
            thisAnswer.save()


    return HttpResponseRedirect(reverse('evalAdv:prepare'))



def combined_session(request):
    
        if request.session["unit"] == "metric":
            return render(request, 'evalAdv/combined_session_de.html')
        elif request.session["unit"] == "us":
            return render(request, 'evalAdv/combined_session.html')
        else:
            pass

def get_combined_session_input(request):
    if request.method == 'POST' and "left_slider_1" in request.POST.keys():
        lowerlim_1 = request.POST["left_slider_1"]
        upperlim_1 = request.POST["right_slider_1"]   


        lowerlim_2 = request.POST["left_slider_2"]
        upperlim_2 = request.POST["right_slider_2"]   

        lowerlim_3 = request.POST["left_slider_3"]
        upperlim_3 = request.POST["right_slider_3"]   

        
        # get participant id from cookie
        pid = request.session["participant_id"]

        unit_type = request.session["unit"]

        prolificid = request.session["prolificid"]
        

        thisCombinedSession = CombinedSessionItem(prolific_id=prolificid, unit_type=unit_type, participant_id=pid,
                                                lower_limes_1 = lowerlim_1,
                                                upper_limes_1 = upperlim_1,
                                                lower_limes_2 = lowerlim_2,
                                                upper_limes_2 = upperlim_2,
                                                lower_limes_3 = lowerlim_3,
                                                upper_limes_3 = upperlim_3
                                                
                                                )

        thisCombinedSession.save()     

        return HttpResponseRedirect(reverse('evalAdv:finished'))


def finished(request):
    return render(request, 'evalAdv/finished.html')  