from scipy import special

import matplotlib.pyplot as plt
import numpy as np
import pandas as pd
import seaborn as sns

import os
import re

# sns.set_theme(style="darkgrid")
# tips = sns.load_dataset("tips")
# sns.relplot(x="total_bill", y="tip", data=tips).savefig("test.png")

csv_path = "content_function"

csvfiles = os.listdir(csv_path)
csvfiles = [fname for fname in csvfiles if "_cf" in fname]

#print(csvfiles)
#print(categories)

# indices from 0 to 12

rank_lens = list()

fig = plt.figure()
fig.set_size_inches(14, 8)
#fig.tight_layout()

# X11 colors for plots
x11_colors = ['red', 'black', 'sienna', 'purple', 'darkorange', 
 'gold', 'greenyellow', 'darkgreen', 'lightseagreen', 'grey',
 'blue', 'cyan', 'hotpink', 'silver', 'gray']

ax = fig.subplots()

df = pd.read_csv(os.path.join(csv_path, csvfiles[0]))
df = df.rename(columns={df.columns[0]: "categories", df.columns[1]: "ratio"})

# for row in df.itertuples():
#     print(row.mask_id)

cat = [row.categories for row in df.itertuples()]
ratio = [row.ratio for row in df.itertuples()]

ax.bar(cat, ratio, width=0.7)
ax.legend()
#plt.xscale('linear')
plt.yscale('linear')

plt.title('Content-Function Word Distribution of each Category in CoDA')
plt.xticks(rotation=75, fontsize=7)
plt.xlabel('Category')
plt.ylabel('CF Ratio')
plt.tight_layout()

#plt.show()
plt.savefig('cf_ratio.png')