function egrad = essential_egradE2egrad(X, egradE)
% Converts the gradient in essential matrix E to the gradient in X.
%
% function egrad = essential_egradE2egrad(X, egradE)
%
% egradE is the function handle for the gradient in E.
% 
% The output is a matrix in the space of X.
%
% See also: essential_costE2cost essential_ehessE2ehess


% This file is part of Manopt: www.manopt.org.
% Original author: Roberto Tron, Aug. 8, 2014
% Contributors: Bamdev Mishra, May 22, 2015.

    e3hat = [0 -1 0; 1 0 0; 0 0 0];
    RA = X(:,1:3,:); 
    RB = X(:,4:6,:);
    E = multiprod(multiprod(multitransp(RA), e3hat), RB); 
    G =  egradE(E); 
    
    %The following is the vectorized version of egrad = e3hat*[RB*G' -RA*G];
    egrad = multiprod(e3hat, cat(2,...
        multiprod(RB, multitransp(G)),...
        -multiprod(RA, G)));
end

