#include "include/basic.h"
#include "weight_base.h"
#include <fstream>

void WeightBase::loadScores() {
    if (input_file_.empty())
        return;

    std::ifstream is(input_file_);
    if (!is) {
        LOG_WARNING(<< "Can not open feature file: " << input_file_);
        return;
    }
    loadScores(is);

    is.close();
}


void WeightBase::saveScores() {
    if (output_file_.empty())
        return;

    std::ofstream os(output_file_);
    if (!os) {
        LOG_WARNING(<< "Can not open feature file: " << output_file_);
        return;
    }
    saveScores(os);

    os.close();
}
