#ifndef MACROS_BASE_H
#define MACROS_BASE_H

#include "include/ngram.h"
#include "include/keyref.h"
#include "io/rule.h"
#include "io/edsgraph.h"

#define MAX_NODE_IN_EDGE_COUNT 32
#define MAX_NODE_OUT_EDGE_COUNT 8
#define MAX_GRAPH_NODE_COUNT 256
#define MAX_VARIABLE_COUNT 4

#define OUTPUT_STEP 1000

using GType = int64_t;
using Int = int;
using UNSIGNED = unsigned int;

using TLemma = GType;
using TNodeLabel = GType;
using TEdgeLabel = GType;
using TDirection = GType;

using TwoInt = BiGram< GType >;
using ThreeInt = TriGram< GType >;
using FourInt = QuarGram< GType >;
using FiveInt = QuinGram< GType >;
using SixInt = HexaGram< GType >;
using SevenInt = SeptGram< GType >;
using BooleanInt = BiGram< GType >;

using TLemmaDirectionInt = TriGram< GType >;
using TNodeDirectionInt = TriGram< GType >;
using TNodeLemmaDirectionInt = QuarGram< GType >;
using TEdgeNodeInt = TriGram< GType >;
using TEdgeLemmaInt = TriGram< GType >;
using TEdgeNodeLemmaInt = QuarGram< GType >;
using TNodeEdgeInt = TriGram< GType >;
using TLemmaEdgeInt = TriGram< GType >;
using TNodeLemmaEdgeInt = QuarGram< GType >;

using T2NodeDirectionInt = QuarGram< GType >;
using T2LemmaDirectionInt = QuarGram< GType >;
using T2Node2Lemma2DirectionInt = HexaGram< GType >;

using RuleIndex = int;

using EdgeStateMap = std::unordered_map< EdsGraph::Arc, RuleSet::State >;

enum Direction {
    eHere = 0,
    eIn,
    eOut,
    eInIn,
    eInOut,
    eOutIn,
    eOutOut
};

#endif /* MACROS_BASE_H */

// Local Variables:
// mode: c++
// End:
