/*
 * Decompiled with CFR 0.152.
 */
package jigsaw.syntax;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import jigsaw.syntax.BitRecChart;
import jigsaw.syntax.Grammar;
import jigsaw.syntax.Lexicon;
import jigsaw.syntax.ParseForest;
import jigsaw.syntax.Rule;
import jigsaw.syntax.Tree;
import jigsaw.treebank.Trees;
import jigsaw.util.StringUtils;

public class Parser {
    int debugcount = 0;
    private double[] _logP = null;
    private double[] _logLP = null;
    private Vector<String> _inputs = null;
    private BitRecChart _chart = null;
    private BitRecChart _ichart = null;
    private Grammar _g = null;
    private Lexicon _l = null;
    private Statistics _stats = new Statistics();

    public Parser(Grammar g, Lexicon l) {
        this._g = g;
        this._l = l;
    }

    public Parser(Grammar g) {
        this._g = g;
        this._l = g.lexicon();
    }

    public Parser(String grammarfile) throws IOException, ClassNotFoundException {
        this._g = (Grammar)new ObjectInputStream(new FileInputStream(grammarfile)).readObject();
        System.out.println("done.");
        this._l = this._g.lexicon();
    }

    public Tree<String> parse(String sentence) {
        List<String> inputs = Parser.tokenize(sentence);
        return this.parse(inputs);
    }

    public Tree<String> parseGoldPos(List<Tree<String>> sentence) {
        ++this._stats.totalSentences;
        long startTime = System.currentTimeMillis();
        this.lexparseGoldPos(sentence);
        this.recognize();
        Tree<String> result = null;
        if (this._chart.recognized()) {
            ++this._stats.successSentences;
            this._stats.successTokens += this._stats.lastTokens;
            this.viterbi();
            result = this.buildVParse();
        } else {
            this.viterbi();
            result = new Tree<String>(this._g.Start());
            List children = this.partialParse();
            result.setChildren(children);
        }
        result = new Trees.GrammarInternalNodeStripper().transformTree(result);
        long endTime = System.currentTimeMillis();
        this._stats.lastParseTime = endTime - startTime;
        this._stats.totalParseTime += this._stats.lastParseTime;
        return result;
    }

    public Tree<String> parse(List<String> sentence) {
        return this.parse(sentence, true);
    }

    public Tree<String> parse(List<String> sentence, boolean word_lattice) {
        ++this._stats.totalSentences;
        long startTime = System.currentTimeMillis();
        if (word_lattice) {
            this.lexparse(sentence);
        } else {
            this.lexparseNoLattice(sentence);
        }
        this.recognize();
        Tree<String> result = null;
        if (this._chart.recognized()) {
            ++this._stats.successSentences;
            this._stats.successTokens += this._stats.lastTokens;
            this.viterbi();
            result = this.buildVParse();
            result = new Trees.GrammarInternalNodeStripper().transformTree(result);
        }
        long endTime = System.currentTimeMillis();
        this._stats.lastParseTime = endTime - startTime;
        this._stats.totalParseTime += this._stats.lastParseTime;
        return result;
    }

    public Tree<String> parseR(List<String> sentence) {
        return this.parseR(sentence, true);
    }

    public Tree<String> parseR(List<String> sentence, boolean word_lattice) {
        ++this._stats.totalSentences;
        long startTime = System.currentTimeMillis();
        if (word_lattice) {
            this.lexparse(sentence);
        } else {
            this.lexparseNoLattice(sentence);
        }
        this.recognize();
        Tree<String> result = null;
        if (this._chart.recognized()) {
            ++this._stats.successSentences;
            this._stats.successTokens += this._stats.lastTokens;
            this.viterbi();
            result = this.buildVParse();
        } else {
            this.viterbi();
            result = new Tree<String>(this._g.Start());
            List children = this.partialParse();
            result.setChildren(children);
        }
        result = new Trees.GrammarInternalNodeStripper().transformTree(result);
        long endTime = System.currentTimeMillis();
        this._stats.lastParseTime = endTime - startTime;
        this._stats.totalParseTime += this._stats.lastParseTime;
        return result;
    }

    public List<Tree<String>> partialParse() {
        ArrayList<Tree<String>> partials = new ArrayList<Tree<String>>();
        short i = 0;
        while (i < this._ichart.maxpos()) {
            double maxscore = Double.NEGATIVE_INFINITY;
            Tree<String> tnode = new Tree<String>(this._inputs.get(i));
            ArrayList children = new ArrayList();
            children.add(tnode);
            Tree<String> ptnode = null;
            int tag = 0;
            while (tag < this._ichart.maxS()) {
                if (this._ichart.get(i, (short)(i + 1), tag) && this.logLP(i, (short)(i + 1), tag) > maxscore) {
                    ptnode = new Tree<String>(this._g.T(this._g.i2T(tag)));
                    maxscore = this.logLP(i, (short)(i + 1), tag);
                }
                ++tag;
            }
            ptnode.setChildren(children);
            partials.add(ptnode);
            i = (short)(i + 1);
        }
        return partials;
    }

    public static List<String> tokenize(String sentence) {
        sentence = sentence.replace(",", " ,");
        sentence = sentence.replace(".", " .");
        sentence = sentence.replace("!", " !");
        sentence = sentence.replace("?", " ?");
        sentence = sentence.replace("'", " '");
        String[] toks = sentence.split("\\s+");
        Vector<String> tokenized = new Vector<String>();
        String[] stringArray = toks;
        int n = toks.length;
        int n2 = 0;
        while (n2 < n) {
            String tok = stringArray[n2];
            tokenized.add(tok);
            ++n2;
        }
        return tokenized;
    }

    public void recognize() {
        short maxpos = (short)this._chart.maxpos();
        int N = this._g.nts().size();
        BitSet vec = new BitSet(N);
        short end = 1;
        while (end <= maxpos) {
            short begin = (short)(end - 2);
            while (begin >= 0) {
                vec.clear();
                int A = 0;
                while (A < N) {
                    if (!vec.get(A)) {
                        for (Rule r : this._g.birules(A)) {
                            BitSet vec1 = this._chart.getVectorByStart(begin, (short)(end - begin - 1), r.rhs()[0]);
                            BitSet vec2 = this._chart.getVectorByEnd(end, (short)(end - begin - 1), r.rhs()[1]);
                            vec1.and(vec2);
                            if (vec1.isEmpty()) continue;
                            vec.or(this._chart.chainvec(A));
                            break;
                        }
                    }
                    ++A;
                }
                this._chart.or(begin, end, vec);
                begin = (short)(begin - 1);
            }
            end = (short)(end + 1);
        }
        this._stats.lastCFR = this._chart.fillrate();
        this._stats.totalCFR += this._stats.lastCFR;
    }

    public void initlogLP() {
        this._logLP = new double[this._ichart.size()];
        int i = 0;
        while (i < this._logLP.length) {
            this._logLP[i] = Double.NaN;
            ++i;
        }
    }

    public void logLP(short start, short end, int tag, double logp) {
        this._logLP[tag * this._ichart.pagesize() + end * (end - 1) / 2 + start] = logp;
    }

    public double logLP(short start, short end, int tag) {
        return this._logLP[tag * this._ichart.pagesize() + end * (end - 1) / 2 + start];
    }

    public void initlogP() {
        this._logP = new double[this._chart.size()];
        int i = 0;
        while (i < this._logP.length) {
            this._logP[i] = Double.NaN;
            ++i;
        }
    }

    public void logP(short start, short end, int nt, double logp) {
        this._logP[nt * this._chart.pagesize() + end * (end - 1) / 2 + start] = logp;
    }

    public double logP(short start, short end, int nt) {
        return this._logP[nt * this._chart.pagesize() + end * (end - 1) / 2 + start];
    }

    public void lexparseGoldPos(List<Tree<String>> inputs) {
        short maxpos = (short)inputs.size();
        this._stats.lastTokens = maxpos;
        this._stats.totalTokens += this._stats.lastTokens;
        this._inputs = new Vector();
        this._chart = new BitRecChart(this._g, maxpos);
        this._ichart = new BitRecChart(maxpos, this._g.ts().size() - 1);
        this.initlogLP();
        int N = this._g.nts().size();
        BitSet vec = new BitSet(N);
        int i = 0;
        for (Tree<String> pt : inputs) {
            String word = StringUtils.join(pt.getYield(), " ");
            this._inputs.add(word);
            int t = this._g.T(pt.getLabel());
            int ti = this._g.T2i(t);
            Iterator<Integer> tagiter = null;
            boolean knownGPOS = false;
            if (ti != -1) {
                knownGPOS = true;
                ArrayList<Integer> taglist = new ArrayList<Integer>();
                taglist.add(ti);
                tagiter = taglist.iterator();
            } else {
                tagiter = this._l.tagIteratorByWord(word, i, true);
            }
            vec.clear();
            while (tagiter.hasNext()) {
                ti = tagiter.next();
                t = this._g.T(this._l.tag(ti));
                this._ichart.set((short)i, (short)(i + 1), ti);
                this.logLP((short)i, (short)(i + 1), ti, knownGPOS ? 0.0 : this._l.score(word, ti, i));
                for (Rule r : this._g.trules()) {
                    if (r.rhs()[0] != t) continue;
                    vec.or(this._chart.chainvec(r.lhs()));
                }
            }
            this._chart.or((short)i, (short)(i + 1), vec);
            ++i;
        }
    }

    public void lexparse(List<String> inputs) {
        short maxpos = (short)inputs.size();
        this._stats.lastTokens = maxpos;
        this._stats.totalTokens += this._stats.lastTokens;
        this._inputs = new Vector<String>(inputs);
        this._chart = new BitRecChart(this._g, maxpos);
        this._ichart = new BitRecChart(maxpos, this._g.ts().size() - 1);
        this.initlogLP();
        int N = this._g.nts().size();
        BitSet vec = new BitSet(N);
        BitSet covered = new BitSet(maxpos);
        short start = 0;
        while (start < maxpos) {
            StringBuffer word = new StringBuffer();
            short end = (short)(start + 1);
            while (end <= maxpos) {
                if (word.length() > 0) {
                    word.append(" ");
                }
                word.append(this._inputs.get(end - 1));
                Iterator<Integer> iter = this._l.tagIteratorByWord(word.toString(), start, false);
                if (iter.hasNext()) {
                    covered.set((int)start, end);
                }
                vec.clear();
                while (iter.hasNext()) {
                    int tag = iter.next();
                    int t = this._g.T(this._l.tag(tag));
                    this._ichart.set(start, end, tag);
                    this.logLP(start, end, tag, this._l.score(word.toString(), tag, start));
                    for (Rule r : this._g.trules()) {
                        if (r.rhs()[0] != t) continue;
                        vec.or(this._chart.chainvec(r.lhs()));
                    }
                }
                this._chart.or(start, end, vec);
                end = (short)(end + 1);
            }
            start = (short)(start + 1);
        }
        short i = 0;
        while (i < maxpos) {
            if (!covered.get(i)) {
                vec.clear();
                Iterator<Integer> iter = this._l.tagIteratorByWord(this._inputs.get(i), i, true);
                while (iter.hasNext()) {
                    int tag = iter.next();
                    int t = this._g.T(this._l.tag(tag));
                    this._ichart.set(i, (short)(i + 1), tag);
                    this.logLP(i, (short)(i + 1), tag, this._l.score(this._inputs.get(i), tag, i));
                    for (Rule r : this._g.trules()) {
                        if (r.rhs()[0] != t) continue;
                        vec.or(this._chart.chainvec(r.lhs()));
                    }
                }
                this._chart.or(i, (short)(i + 1), vec);
            }
            i = (short)(i + 1);
        }
    }

    public void lexparseNoLattice(List<String> inputs) {
        short maxpos = (short)inputs.size();
        this._stats.lastTokens = maxpos;
        this._stats.totalTokens += this._stats.lastTokens;
        this._inputs = new Vector<String>(inputs);
        this._chart = new BitRecChart(this._g, maxpos);
        this._ichart = new BitRecChart(maxpos, this._g.ts().size() - 1);
        this.initlogLP();
        int N = this._g.nts().size();
        BitSet vec = new BitSet(N);
        short start = 0;
        while (start < maxpos) {
            Iterator<Integer> iter = this._l.tagIteratorByWord(inputs.get(start), start, false);
            if (!iter.hasNext()) {
                iter = this._l.tagIteratorByWord(this._inputs.get(start), start, true);
            }
            vec.clear();
            while (iter.hasNext()) {
                int tag = iter.next();
                int t = this._g.T(this._l.tag(tag));
                this._ichart.set(start, (short)(start + 1), tag);
                this.logLP(start, (short)(start + 1), tag, this._l.score(inputs.get(start), tag, start));
                for (Rule r : this._g.trules()) {
                    if (r.rhs()[0] != t) continue;
                    vec.or(this._chart.chainvec(r.lhs()));
                }
            }
            this._chart.or(start, (short)(start + 1), vec);
            start = (short)(start + 1);
        }
    }

    public void viterbi() {
        this.initlogP();
        short end = 1;
        while (end <= this._chart.maxpos()) {
            short start = (short)(end - 1);
            while (start >= 0) {
                for (Rule r : this._g.trules()) {
                    int ti = this._g.T2i(r.rhs()[0]);
                    if (!this._chart.get(start, end, r.lhs()) || !this._ichart.get(start, end, ti)) continue;
                    this.addProb(start, (short)0, end, r);
                }
                start = (short)(start - 1);
            }
            start = (short)(end - 2);
            while (start >= 0) {
                int A = 0;
                while (A <= this._chart.maxS()) {
                    if (this._chart.get(start, end, A)) {
                        for (Rule r : this._g.birules(A)) {
                            BitSet vec1 = this._chart.getVectorByStart(start, (short)(end - start - 1), r.rhs()[0]);
                            BitSet vec2 = this._chart.getVectorByEnd(end, (short)(end - start - 1), r.rhs()[1]);
                            vec1.and(vec2);
                            int m = vec1.nextSetBit(0);
                            while (m >= 0) {
                                this.addProb(start, (short)(start + m + 1), end, r);
                                m = vec1.nextSetBit(m + 1);
                            }
                        }
                    }
                    ++A;
                }
                start = (short)(start - 1);
            }
            end = (short)(end + 1);
        }
    }

    public void addProb(short start, short mid, short end, Rule r) {
        double oldlp;
        double logp = this._g.logProb(r.id());
        if (r.arity() == 1 && r.rhs()[0] < 0) {
            int ti = this._g.T2i(r.rhs()[0]);
            logp += this.logLP(start, end, ti);
        } else if (r.arity() == 1) {
            logp += this.logP(start, end, r.rhs()[0]);
        } else if (r.arity() == 2) {
            logp += this.logP(start, mid, r.rhs()[0]) + this.logP(mid, end, r.rhs()[1]);
        }
        if (logp == Double.NEGATIVE_INFINITY) {
            System.out.println("break here 1");
            System.exit(1);
        }
        if (Double.isNaN(oldlp = this.logP(start, end, r.lhs())) || oldlp < logp) {
            if (logp == Double.NEGATIVE_INFINITY) {
                System.out.println("break here 2");
                System.exit(2);
            }
            this.logP(start, end, r.lhs(), logp);
            for (Rule rc : this._g.revchainrules(r.lhs())) {
                this.addProb(start, (short)0, end, rc);
            }
        }
    }

    public Tree<String> buildVParse() {
        return this.buildVParse((short)0, (short)this._chart.maxpos(), this._g.S());
    }

    public Tree<String> buildVParse(short start, short end, int A) {
        Tree<String> node = new Tree<String>(this._g.NT(A));
        ArrayList children = new ArrayList();
        node.setChildren(children);
        for (Rule r : this._g.trules(A)) {
            int ti = this._g.T2i(r.rhs()[0]);
            if (!this._ichart.get(start, end, ti) || this.logP(start, end, A) != this._g.logProb(r.id()) + this.logLP(start, end, ti)) continue;
            Tree<String> ctag = new Tree<String>(this._g.T(r.rhs()[0]));
            Tree<String> cword = new Tree<String>(StringUtils.join(this._inputs.subList(start, end), " "));
            ArrayList cs = new ArrayList();
            cs.add(cword);
            ctag.setChildren(cs);
            children.add(ctag);
            return node;
        }
        for (Rule r : this._g.chainrules(A)) {
            if (!this._chart.get(start, end, r.rhs()[0]) || !(this.logP(start, end, A) > Double.NEGATIVE_INFINITY) || this.logP(start, end, A) != this.logP(start, end, r.rhs()[0]) + this._g.logProb(r.id())) continue;
            ++this.debugcount;
            if (this.debugcount == 1000) {
                System.out.println("break here 3");
            }
            node.getChildren().add(this.buildVParse(start, end, r.rhs()[0]));
            return node;
        }
        for (Rule r : this._g.birules(A)) {
            BitSet vec1 = this._chart.getVectorByStart(start, (short)(end - start - 1), r.rhs()[0]);
            BitSet vec2 = this._chart.getVectorByEnd(end, (short)(end - start - 1), r.rhs()[1]);
            vec1.and(vec2);
            int m = vec1.nextSetBit(0);
            while (m >= 0) {
                if (this.logP(start, end, A) == this.logP(start, (short)(start + m + 1), r.rhs()[0]) + this.logP((short)(start + m + 1), end, r.rhs()[1]) + this._g.logProb(r.id())) {
                    Tree<String> lc = this.buildVParse(start, (short)(start + m + 1), r.rhs()[0]);
                    Tree<String> rc = this.buildVParse((short)(start + m + 1), end, r.rhs()[1]);
                    node.getChildren().add(lc);
                    node.getChildren().add(rc);
                    return node;
                }
                m = vec1.nextSetBit(m + 1);
            }
        }
        return null;
    }

    public void printVParse(Writer w) throws IOException {
        w.write(String.valueOf(Math.exp(this.logP((short)0, (short)this._chart.maxpos(), this._g.NT(this._g.Start())))) + ":");
        this.printVParse((short)0, (short)this._chart.maxpos(), this._g.NT(this._g.Start()), w);
        w.flush();
    }

    public void printVParse(short start, short end, int A, Writer w) throws IOException {
        w.write("(" + this._g.NT(A) + " ");
        for (Rule r : this._g.trules(A)) {
            int ti = this._g.T2i(r.rhs()[0]);
            if (!this._ichart.get(start, end, ti) || this.logP(start, end, A) != this._g.logProb(r.id()) + this.logLP(start, end, ti)) continue;
            w.write("(" + this._g.T(r.rhs()[0]) + " \"" + this._inputs.get(start));
            int i = start + 1;
            while (i < end) {
                w.write(" " + this._inputs.get(i));
                ++i;
            }
            w.write("\"))");
            return;
        }
        for (Rule r : this._g.chainrules(A)) {
            if (!this._chart.get(start, end, r.rhs()[0]) || this.logP(start, end, A) != this.logP(start, end, r.rhs()[0]) + this._g.logProb(r.id())) continue;
            this.printVParse(start, end, r.rhs()[0], w);
            w.write(")");
            return;
        }
        for (Rule r : this._g.birules(A)) {
            BitSet vec1 = this._chart.getVectorByStart(start, (short)(end - start - 1), r.rhs()[0]);
            BitSet vec2 = this._chart.getVectorByEnd(end, (short)(end - start - 1), r.rhs()[1]);
            vec1.and(vec2);
            int m = vec1.nextSetBit(0);
            while (m >= 0) {
                if (this.logP(start, end, A) == this.logP(start, (short)(start + m + 1), r.rhs()[0]) + this.logP((short)(start + m + 1), end, r.rhs()[1]) + this._g.logProb(r.id())) {
                    this.printVParse(start, (short)(start + m + 1), r.rhs()[0], w);
                    this.printVParse((short)(start + m + 1), end, r.rhs()[1], w);
                    w.write(")");
                    return;
                }
                m = vec1.nextSetBit(m + 1);
            }
        }
    }

    public Statistics stats() {
        return this._stats;
    }

    public BitRecChart chart() {
        return this._chart;
    }

    public BitRecChart ichart() {
        return this._ichart;
    }

    public static void main(String[] args) {
        block11: {
            try {
                if (args[0].equals("-f")) {
                    Grammar grammar = new Grammar();
                    grammar.loadGrammar(args[1]);
                    grammar.normalize();
                    Lexicon lexicon = new Lexicon(grammar.ts());
                    lexicon.loadLexicon(args[2]);
                    Parser parser = new Parser(grammar, lexicon);
                    parser.lexparse(Parser.tokenize(args[3]));
                    parser.recognize();
                    if (parser._chart.recognized()) {
                        System.out.println("Yes");
                    } else {
                        System.out.println("No");
                    }
                    ParseForest forest = new ParseForest(parser._chart, parser._ichart, grammar);
                    forest.debugPrint();
                    System.out.println("Done.");
                    break block11;
                }
                if (args[0].equals("-v")) {
                    System.out.print("Loading grammar ... ");
                    Grammar grammar = new Grammar();
                    grammar.loadGrammar(args[1]);
                    grammar.normalize();
                    System.out.println("done.");
                    System.out.print("Loading lexicon ... ");
                    Lexicon lexicon = new Lexicon(grammar.ts());
                    lexicon.loadLexicon(args[2]);
                    System.out.println("done.");
                    Parser parser = new Parser(grammar, lexicon);
                    long startTime = System.currentTimeMillis();
                    parser.lexparse(Parser.tokenize(args[3]));
                    long endTime = System.currentTimeMillis();
                    System.out.println("lexparse(): " + (endTime - startTime) + " ms");
                    startTime = System.currentTimeMillis();
                    parser.recognize();
                    endTime = System.currentTimeMillis();
                    System.out.println("recognize(): " + (endTime - startTime) + " ms");
                    if (parser._chart.recognized()) {
                        System.out.println("Yes");
                    } else {
                        System.out.println("No");
                        System.exit(1);
                    }
                    startTime = System.currentTimeMillis();
                    parser.viterbi();
                    endTime = System.currentTimeMillis();
                    System.out.println("viterbi(): " + (endTime - startTime) + " ms");
                    startTime = System.currentTimeMillis();
                    Tree<String> parse = parser.buildVParse();
                    endTime = System.currentTimeMillis();
                    System.out.println("buildVParse(): " + (endTime - startTime) + " ms");
                    Tree<String> result = new Trees.GrammarInternalNodeStripper().transformTree(parse);
                    System.out.println(Trees.PennTreeRenderer.render(result));
                    System.out.println();
                    break block11;
                }
                if (!args[0].endsWith("-b")) break block11;
                System.out.print("Loading grammar ... ");
                Grammar grammar = (Grammar)new ObjectInputStream(new FileInputStream(args[1])).readObject();
                System.out.println("done.");
                Parser parser = new Parser(grammar);
                BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                String sentence = null;
                while ((sentence = br.readLine()) != null) {
                    if (!sentence.equals("")) {
                        long startTime = System.currentTimeMillis();
                        parser.lexparse(Parser.tokenize(sentence));
                        long endTime = System.currentTimeMillis();
                        System.out.println("lexparse(): " + (endTime - startTime) + " ms");
                        startTime = System.currentTimeMillis();
                        parser.recognize();
                        endTime = System.currentTimeMillis();
                        System.out.println("recognize(): " + (endTime - startTime) + " ms");
                        System.out.println("Chart filling rate (before filtering): " + parser._chart.fillrate());
                        if (!parser._chart.recognized()) {
                            System.out.println("No");
                            parser.viterbi();
                            Tree<String> rtree = new Tree<String>(parser._g.Start());
                            List children = parser.partialParse();
                            rtree.setChildren(children);
                            Tree<String> result = new Trees.GrammarInternalNodeStripper().transformTree(rtree);
                            System.out.println(Trees.PennTreeRenderer.render(result));
                            continue;
                        }
                        System.out.println("Yes");
                        startTime = System.currentTimeMillis();
                        parser.viterbi();
                        endTime = System.currentTimeMillis();
                        System.out.println("viterbi(): " + (endTime - startTime) + " ms");
                        startTime = System.currentTimeMillis();
                        Tree<String> parse = parser.buildVParse();
                        endTime = System.currentTimeMillis();
                        System.out.println("buildVParse(): " + (endTime - startTime) + " ms");
                        Tree<String> result = new Trees.GrammarInternalNodeStripper().transformTree(parse);
                        System.out.println(Trees.PennTreeRenderer.render(result));
                        System.out.println();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static class Statistics {
        public int totalSentences = 0;
        public int totalTokens = 0;
        public int successSentences = 0;
        public int successTokens = 0;
        public long totalParseTime = 0L;
        public double totalCFR = 0.0;
        public double lastCFR = 0.0;
        public long lastParseTime = 0L;
        public int lastTokens = 0;

        public double coverage() {
            return (double)this.successSentences / (double)this.totalSentences;
        }

        public double averageSentenceLength() {
            return (double)this.totalTokens / (double)this.totalSentences;
        }

        public double averageCFR() {
            return this.totalCFR / (double)this.totalSentences;
        }

        public double averageSuccessSentenceLength() {
            return (double)this.successTokens / (double)this.successSentences;
        }

        public double averageSpeed() {
            return 1000.0 * (double)this.totalTokens / (double)this.totalParseTime;
        }

        public double averageParseTimePerSentence() {
            return (double)this.totalParseTime / (double)this.totalSentences;
        }
    }
}

