/*
 * Decompiled with CFR 0.152.
 */
package fig.prob;

import fig.basic.MapUtils;
import fig.basic.TDoubleMap;
import fig.prob.Distrib;
import fig.prob.SparseMultinomialSuffStats;
import fig.prob.SuffStats;
import java.util.Random;

public class SparseMultinomial
implements Distrib<Object> {
    private TDoubleMap probs;

    public SparseMultinomial(TDoubleMap probs) {
        this.probs = probs;
    }

    public double logProb(Object x) {
        return Math.log(this.probs.get(x, 0.0));
    }

    @Override
    public double logProb(SuffStats _stats) {
        SparseMultinomialSuffStats stats = (SparseMultinomialSuffStats)_stats;
        double sum = 0.0;
        for (TDoubleMap.Entry e : stats) {
            sum += e.getValue() * this.logProb(e.getKey());
        }
        return sum;
    }

    @Override
    public double logProbObject(Object x) {
        return this.logProb(x);
    }

    public static Object sample(Random random, TDoubleMap probs) {
        double v = random.nextDouble();
        double sum = 0.0;
        for (TDoubleMap.Entry e : probs) {
            if (!(v < (sum += e.getValue()))) continue;
            return e.getKey();
        }
        throw new RuntimeException(String.valueOf(sum) + " < " + v);
    }

    public Object sample(Random random) {
        return SparseMultinomial.sample(random, this.probs);
    }

    @Override
    public Object sampleObject(Random random) {
        return this.sample(random);
    }

    @Override
    public double crossEntropy(Distrib<Object> _that) {
        throw new RuntimeException("Not implemented");
    }

    public TDoubleMap getProbs() {
        return this.probs;
    }

    public String toString() {
        return String.format("Multinomial(%s)", MapUtils.topNToString(this.probs, 30));
    }
}

