/*
 * Decompiled with CFR 0.152.
 */
package fig.basic;

import fig.basic.LogInfo;
import fig.basic.StopWatch;

class LogRun {
    int numLines;
    int numLinesPrinted;
    int nextLineToPrint;
    StopWatch watch = new StopWatch();
    boolean printAllLines;
    boolean forcePrint;

    public LogRun() {
        this.init();
    }

    void init() {
        this.numLines = 0;
        this.numLinesPrinted = 0;
        this.nextLineToPrint = 0;
        this.printAllLines = false;
        this.watch.reset();
        this.watch.start();
    }

    void finish() {
        this.nextLineToPrint = -1;
        this.watch.stop();
    }

    void forcePrint() {
        this.forcePrint = true;
    }

    boolean shouldPrint() {
        return this.forcePrint || this.nextLineToPrint == this.numLines;
    }

    int numOmitted() {
        return this.numLines - this.numLinesPrinted;
    }

    boolean newLine() {
        long elapsed_ms;
        boolean p = this.shouldPrint();
        ++this.numLines;
        if (!p) {
            return false;
        }
        ++this.numLinesPrinted;
        int msPerLine = LogInfo.msPerLine;
        this.nextLineToPrint = this.numLines <= 2 || msPerLine == 0 || this.printAllLines || this.forcePrint ? ++this.nextLineToPrint : ((elapsed_ms = this.watch.getCurrTimeLong()) == 0L ? (this.nextLineToPrint *= 2) : (this.nextLineToPrint += (int)Math.max((double)this.numLines * (double)msPerLine / (double)elapsed_ms, 1.0)));
        this.forcePrint = false;
        return true;
    }
}

