theory question_21_4

imports Main

begin

typedecl entity

consts
  Birds :: "entity ⇒ bool"
  EndothermicTetrapodVertebrate :: "entity ⇒ bool"
  Belong :: "entity ⇒ entity ⇒ bool"
  ClassAves :: "entity"
  Aves :: "entity ⇒ bool"

(* Explanation 1: Birds are a type of endothermic tetrapod vertebrates that belong to the official taxonomic classification for birds, which is Class Aves. *)
axiomatization where
  explanation_1: "∀x. Birds x ⟶ (EndothermicTetrapodVertebrate x ∧ Belong x ClassAves)"

(* Explanation 2: Endothermic tetrapod vertebrates that belong to Class Aves are birds (i.e., a member of the class Aves). *)
axiomatization where
  explanation_2: "∀x. (EndothermicTetrapodVertebrate x ∧ Belong x ClassAves) ⟶ Birds x"

(* Explanation 3: Class Aves is the official taxonomic classification for birds, and any endothermic tetrapod vertebrate that belongs to Class Aves is an animal in the class aves. *)
axiomatization where
  explanation_3: "∀x. Belong x ClassAves ⟶ Aves x" and
  explanation_4: "∀x. (EndothermicTetrapodVertebrate x ∧ Belong x ClassAves) ⟶ Aves x"

theorem hypothesis:
  assumes asm: "EndothermicTetrapodVertebrate x"
  (* Hypothesis: An endothermic tetrapod vertebrate would be animals in the class aves. *)
  shows "Aves x"
proof -
  from asm have "EndothermicTetrapodVertebrate x ∧ Belong x ClassAves" by simp
  then show "Aves x" by (rule explanation_2)
qed

end
