theory question_74_0

imports Main

begin

typedecl entity
typedecl event

consts
  NonWoodFibers :: "entity ⇒ bool"
  Paper :: "entity ⇒ bool"
  Pulled :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation 2: Dozens of non-wood fibers are pulped for paper around the world. *)
axiomatization where
  explanation_2: "∀x y e. NonWoodFibers x ∧ Paper y ∧ Pulled e ∧ Agent e x ∧ Patient e y"

theorem hypothesis:
  assumes asm: "PulpingFibers x ∧ Paper y ∧ SaveTrees e ∧ Agent e x ∧ Patient e y"
  (* Hypothesis: Pulping fibres for paper saves trees. *)
  shows "∃x y e. NonWoodFibers x ∧ Paper y ∧ Pulled e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "PulpingFibers x ∧ Paper y ∧ SaveTrees e ∧ Agent e x ∧ Patient e y" by simp
  then obtain e1 where e1: "NonWoodFibers x ∧ Pulled e1 ∧ Agent e1 x ∧ Patient e1 y" using explanation_2 by blast
  then have "Paper y" using explanation_1 by blast
  have conclusion: "NonWoodFibers x ∧ Pulled e1 ∧ Agent e1 x ∧ Patient e1 y" using e1 by simp
  show ?thesis using asm conclusion `Paper y` by blast
qed

end
