theory question_21_1

imports Main

begin

typedecl entity
typedecl event

consts
  ClassAves :: "entity ⇒ bool"
  Birds :: "entity ⇒ bool"
  AnimalInClassAves :: "entity ⇒ bool"

(* Explanation 1: Class Aves is for the birds, literally, and birds are animals in Class Aves. *)
axiomatization where
  explanation_1: "∀x. ClassAves x ∧ Birds x ∧ AnimalInClassAves x"

theorem hypothesis:
  assumes asm: "EndothermicTetrapodVertebrate x ∧ AnimalInClassAves x"
  (* Hypothesis: An endothermic tetrapod vertebrate would be animals in the class aves. *)
  shows "∃x. ClassAves x ∧ Birds x"
proof -
  from asm have "EndothermicTetrapodVertebrate x ∧ AnimalInClassAves x" by simp
  then obtain e1 where e1: "ClassAves x ∧ Birds x" using explanation_1 by blast
  then have "Birds x" using e1 by simp
  show ?thesis using asm "Birds x" by blast
qed

end
