theory question_81_10

imports Main

begin

typedecl entity
typedecl event

consts
  Soil :: "entity ⇒ bool"
  Environments :: "entity ⇒ bool"
  Forest :: "entity ⇒ bool"
  NonlivingComponent :: "entity ⇒ entity ⇒ bool"
  NonlivingPart :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: Soil is typically a nonliving component of environments, such as forests, and specifically a nonliving part of a forest. *)
axiomatization where
  explanation_1: "∀x y z. Soil x ∧ Environments y ∧ Forest z ⟶ (NonlivingComponent x y ∧ NonlivingPart x z)"

theorem hypothesis:
  assumes asm: "Soil x ∧ Forest y"
  (* Hypothesis: Soil is a nonliving part of a forest. *)
  shows "NonlivingPart x y"
proof -
  from asm have "Soil x" and "Forest y" by auto
  then have "NonlivingPart x y" using explanation_1 by blast
  then show ?thesis using `Soil x` `Forest y` by blast
qed

end
