theory question_78_1
imports Main
begin

typedecl entity
typedecl event

consts
  Mirror :: "entity ⇒ bool"
  ShinySurface :: "entity ⇒ bool"
  Reflect :: "event ⇒ bool"
  Made :: "event ⇒ bool"
  Purpose :: "event ⇒ entity ⇒ bool"
  ReflectLight :: "entity ⇒ bool"

(* Explanation 1: A mirror has a shiny surface. *)
axiomatization where
  explanation_1: "∀x. Mirror x ⟶ ShinySurface x"

(* Explanation 2: Shiny things, including objects like mirrors, reflect light. *)
axiomatization where
  explanation_2: "∀x. ShinySurface x ⟶ (∃e. Mirror x ∧ Reflect e ∧ Purpose e x ReflectLight)"

(* Explanation 3: A mirror is a kind of reflective object that is designed to reflect light. *)
axiomatization where
  explanation_3: "∀x e. Mirror x ∧ Reflect x ∧ Made e ⟶ Purpose e x ReflectLight"

theorem hypothesis:
  assumes asm: "Mirror x"
  (* Hypothesis: A mirror is made to reflect light. *)
  shows "∃e. Reflect e ∧ Made e ∧ Purpose e x ReflectLight"
proof -
  from asm have "Mirror x" by simp
  then obtain e where e: "Reflect e ∧ Purpose e x ReflectLight" using explanation_2 by blast
  then have "Made e" using explanation_3 by blast
  have conclusion: "Reflect e ∧ Made e ∧ Purpose e x ReflectLight" using e `Made e` by blast
  show ?thesis using conclusion by blast
qed

end
