theory question_45_0
imports Main

begin
typedecl entity
typedecl event

consts
  Woman :: "entity ⇒ bool"
  Running :: "event ⇒ bool"
  DownTheStreet :: "event ⇒ bool"
  Outdoors :: "event ⇒ bool"
  BlackClothing :: "entity ⇒ bool"
  Barefoot :: "event ⇒ bool"
  NextTo :: "event ⇒ entity ⇒ bool ⇒ bool"
  PeopleOnBicycles :: "entity"
  FemaleRunner :: "entity"

(* Explanation 1: A woman running down the street is outdoors. *)
axiomatization where
  explanation_1: "∃x e. Woman x ∧ Running e ∧ DownTheStreet e ∧ Outdoors e"

theorem hypothesis:
  (* Premise: A woman in black clothing runs down the street barefoot next to two people on bicycles and a female runner. *)
  assumes asm: "Woman x ∧ BlackClothing x ∧ Running e ∧ DownTheStreet e ∧ Barefoot e ∧ NextTo e PeopleOnBicycles True ∧ NextTo e FemaleRunner True"
  (* Hypothesis: The woman is outdoors. *)
  shows "∃x e. Woman x ∧ Outdoors e ∧ Is e x"
proof -
  from asm have "Woman x ∧ Running e ∧ DownTheStreet e ∧ Outdoors e" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
