## **1. Dependencies**

Run the following commands to create a conda environment (assuming CUDA11):
See the file requirements.txt for all environment dependencies.

## **2. Download Data**

We use preprocessed data from the [QA-GNN](https://github.com/michiyasunaga/qagnn) repository.
The data file structure will look like as follows:

```palin
.
├── data/
    ├── cpnet/                     (prerocessed ConceptNet)
    		├── conceptnet-assertions-5.6.0.csv
    		├── conceptnet.en.csv
    		├── conceptnet.en.pruned.graph
    		├── conceptnet.en.unpruned.graph
    		├── tzw.ent.npy
    		├── ...
    ├── csqa/
        ├── train_rand_split.jsonl
        ├── dev_rand_split.jsonl
        ├── test_rand_split_no_answers.jsonl
        ├── statement/             (converted statements)
        ├── grounded/              (grounded entities)
        ├── graphs/                (extracted subgraphs)
        ├── ...
    ├── obqa/
```

## 3. Train ACENet

- Experiment on dataset CommonsenseQA, run

```
sh run_acenet_csqa.sh
```

- Experiment on dataset OpenbookQA, run

```
sh run_acenet_obqa.sh
```

## 4. Pretrained model checkpoints

CommonsenseQA

<table>
  <tr>
    <th>Trained model</th>
    <th>In-house Dev acc.</th>
    <th>In-house Test acc.</th>
  </tr>
  <tr>
    <th>RoBERTa-large + ACENet <a href="https://pan.baidu.com/">[link]</a></th>
    <th>78.8</th>
    <th>74.5</th>
  </tr>
   <tr>
    <th>RoBERTa-large + ACENet <a href="https://pan.baidu.com/">[link]</a></th>
    <th>78.1</th>
    <th>75.2</th>
  </tr>
</table>

OpenBookQA

<table>
  <tr>
    <th>Trained model</th>
    <th>Dev acc.</th>
    <th>Test acc.</th>
  </tr>
  <tr>
    <th>RoBERTa-large + ACENet <a href="https://pan.baidu.com/">[link]</a></th>
    <th>70.2</th>
    <th>70.4</th>
  </tr>
  <tr>
    <th>AristoRoBERTa-large + ACENet <a href="https://pan.baidu.com/">[link]</a></th>
    <th>81.4</th>
    <th>83.2</th>
  </tr>
</table>

## 5. Evaluating a pretrained model checkpoint

## 6. Acknowledgment

This repo is built upon the following work:

```plain
QA-GNN: Question Answering using Language Models and Knowledge Graphs
https://github.com/michiyasunaga/qagnn
```

Many thanks to the authors and developers!
