import hydra
import omegaconf.dictconfig
import pathlib
import logging
import boto3
import IPython

from GenerateQualification import generate_qualification
from GenerateSurvey import generate_survey

logger = logging.getLogger(__name__)


def deploy_qualification(config: omegaconf.dictconfig.DictConfig, questions: str = None, answers: str =None) -> str:

    if questions is None:
        assert pathlib.Path(config.results.question_path).exists()
        with open(config.results.question_path, mode='r') as f:
            questions = f.read()

    if answers is None:
        assert pathlib.Path(config.results.answer_path).exists()
        with open(config.results.answer_path, mode='r') as f:
            answers = f.read()

    mturk = boto3.client('mturk', **config.aws)
    qual_response = mturk.create_qualification_type(
        Test=questions,
        AnswerKey=answers,
        Name=config.qualification.Name,
        Keywords=config.qualification.Keywords,
        Description=config.qualification.Description,
        QualificationTypeStatus=config.qualification.QualificationTypeStatus,
        TestDurationInSeconds=int(config.qualification.TestDurationInSeconds),
    )

    qual_id = qual_response['QualificationType']['QualificationTypeId']
    logger.info(f"qualification id: {qual_id}")
    return qual_id


def deploy_hit(config: omegaconf.dictconfig.DictConfig, qual_id: str, survey: str = None):

    if survey is None:
        assert pathlib.Path(config.results.survey_path).exists()
        with open(config.results.survey_path, 'r') as fp:
            survey = fp.read()

    mturk = boto3.client('mturk', **config.aws)
    hit = mturk.create_hit(
        # Question=survey,
        Reward=str(config.survey.Reward),
        LifetimeInSeconds=config.survey.LifetimeInSeconds,
        AssignmentDurationInSeconds=config.survey.AssignmentDurationInSeconds,
        MaxAssignments=config.survey.MaxAssignments,
        Title=config.survey.Title,
        Description=config.survey.Description,
        Keywords=config.survey.Keywords,
        AutoApprovalDelayInSeconds=config.survey.AutoApprovalDelayInSeconds,
        QualificationRequirements=[{'QualificationTypeId': qual_id, #'3CFGE88WF7UDUETM7YP3RSRD73VS4F',
                                    'Comparator': 'EqualTo',
                                    'IntegerValues': [int(config.survey.QualificationMinScore)]}]
    )
    logger.info(hit)
    return hit


@hydra.main(config_path='../../Configs/MTurkConfig.yaml')
def main(config):
    # '3U8E87MA7YISNK00Q923WOUPQZY94G'
    # generate qualification and deploy it
    if config.qualificationID is None:
        qual_questions, qual_answers = generate_qualification(config, style='image')
        qual_id = deploy_qualification(config, questions=qual_questions, answers=qual_answers)
        logger.info(f'Generated qualification ID: {qual_id}')
    else:
        qual_id = config.qualificationID
        logger.info(f'Loading qualification ID: {qual_id}')

    # generate survey and deploy it
    survey = generate_survey(config)

    # FIXME: There is no solution to upload the batch of HITs
    # deploy_hit(config, qual_id=qual_id, survey=survey)


if __name__ == '__main__':
    main()
