/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.treebank;

import edu.stanford.nlp.international.arabic.pipeline.ATBArabicDataset;
import edu.stanford.nlp.trees.treebank.ConfigParser;
import edu.stanford.nlp.trees.treebank.Dataset;
import edu.stanford.nlp.trees.treebank.DistributionPackage;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.StringUtils;
import java.util.Date;
import java.util.Map;
import java.util.Properties;

public final class TreebankPreprocessor {
    private static final int MIN_ARGS = 1;
    private static boolean VERBOSE = false;
    private static boolean MAKE_DISTRIB = false;
    private static String distribName = null;
    private static String configFile = null;
    private static String outputPath = null;
    public static final Map<String, Integer> optionArgDefs = Generics.newHashMap();

    private TreebankPreprocessor() {
    }

    private static String usage() {
        String cmdLineFormat = String.format("java %s [OPTIONS] config_file%n", TreebankPreprocessor.class.getName());
        StringBuilder sb = new StringBuilder(cmdLineFormat);
        sb.append("  -v         : Show verbose output\n");
        sb.append("  -d <name>  : Make a distributable package with the specified name\n");
        return sb.toString();
    }

    private static Dataset getDatasetClass(Properties dsParams) {
        Dataset ds = null;
        String dsType = dsParams.getProperty("TYPE");
        dsParams.remove("TYPE");
        try {
            if (dsType == null) {
                ds = new ATBArabicDataset();
            } else {
                Class<?> c = ClassLoader.getSystemClassLoader().loadClass(dsType);
                ds = (Dataset)c.newInstance();
            }
        }
        catch (ClassNotFoundException e) {
            System.err.printf("Dataset type %s does not exist\n", dsType);
        }
        catch (InstantiationException e) {
            System.err.printf("Unable to instantiate dataset type %s\n", dsType);
        }
        catch (IllegalAccessException e) {
            System.err.printf("Unable to access dataset type %s\n", dsType);
        }
        return ds;
    }

    private static boolean validateCommandLine(String[] args) {
        Map<String, String[]> argsMap = StringUtils.argsToMap(args, optionArgDefs);
        for (Map.Entry<String, String[]> opt : argsMap.entrySet()) {
            String key = opt.getKey();
            if (key == null) continue;
            if (key.equals("-d")) {
                MAKE_DISTRIB = true;
                distribName = opt.getValue()[0];
                continue;
            }
            if (key.equals("-v")) {
                VERBOSE = true;
                continue;
            }
            if (key.equals("-p")) {
                outputPath = opt.getValue()[0];
                continue;
            }
            return false;
        }
        String[] rest = argsMap.get(null);
        if (rest == null || rest.length != 1) {
            return false;
        }
        configFile = rest[0];
        return true;
    }

    public static void main(String[] args) {
        if (!TreebankPreprocessor.validateCommandLine(args)) {
            System.err.println(TreebankPreprocessor.usage());
            System.exit(-1);
        }
        Date startTime = new Date();
        System.out.println("##################################");
        System.out.println("# Stanford Treebank Preprocessor #");
        System.out.println("##################################");
        System.out.printf("Start time: %s\n", startTime);
        System.out.printf("Configuration: %s\n\n", configFile);
        ConfigParser cp = new ConfigParser(configFile);
        cp.parse();
        DistributionPackage distrib = new DistributionPackage();
        for (Properties dsParams : cp) {
            boolean lacksRequiredOptions;
            Dataset ds;
            String nameOfDataset;
            String string = nameOfDataset = PropertiesUtils.hasProperty(dsParams, "NAME") ? dsParams.getProperty("NAME") : "UN-NAMED";
            if (outputPath != null) {
                dsParams.setProperty("OUTPUT_PATH", outputPath);
            }
            if ((ds = TreebankPreprocessor.getDatasetClass(dsParams)) == null) {
                System.out.printf("Unable to instantiate TYPE for dataset %s. Check the javadocs\n", nameOfDataset);
                continue;
            }
            boolean shouldDistribute = dsParams.contains("DISTRIB") && Boolean.parseBoolean(dsParams.getProperty("DISTRIB"));
            dsParams.remove("DISTRIB");
            boolean bl = lacksRequiredOptions = !ds.setOptions(dsParams);
            if (lacksRequiredOptions) {
                System.out.printf("Skipping dataset %s as it lacks required parameters. Check the javadocs\n", nameOfDataset);
                continue;
            }
            ds.build();
            if (shouldDistribute) {
                distrib.addFiles(ds.getFilenames());
            }
            if (!VERBOSE) continue;
            System.out.println(ds.toString() + "\n");
        }
        if (MAKE_DISTRIB) {
            distrib.make(distribName);
        }
        if (VERBOSE) {
            System.out.println("-->configuration details");
            System.out.println(cp.toString());
            if (MAKE_DISTRIB) {
                System.out.println("-->distribution package details");
                System.out.println(distrib.toString());
            }
        }
        Date stopTime = new Date();
        long elapsedTime = stopTime.getTime() - startTime.getTime();
        System.out.printf("Completed processing at %s\n", stopTime);
        System.out.printf("Elapsed time: %d seconds\n", (int)((float)elapsedTime / 1000.0f));
    }

    static {
        optionArgDefs.put("-d", 1);
        optionArgDefs.put("-v", 0);
        optionArgDefs.put("-p", 1);
    }
}

