/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser.demo;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.parser.lexparser.LexicalizedParser;
import edu.stanford.nlp.process.DocumentPreprocessor;
import edu.stanford.nlp.process.Tokenizer;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.GrammaticalStructureFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.trees.TypedDependency;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

class ParserDemo2 {
    ParserDemo2() {
    }

    public static void main(String[] args) throws IOException {
        ArrayList<List<HasWord>> sentences;
        String grammar = args.length > 0 ? args[0] : "edu/stanford/nlp/models/lexparser/englishPCFG.ser.gz";
        String[] options = new String[]{"-maxLength", "80", "-retainTmpSubcategories"};
        LexicalizedParser lp = LexicalizedParser.loadModel(grammar, options);
        TreebankLanguagePack tlp = lp.getOp().langpack();
        GrammaticalStructureFactory gsf = tlp.grammaticalStructureFactory();
        if (args.length > 1) {
            DocumentPreprocessor dp = new DocumentPreprocessor(args[1]);
            ArrayList<List<HasWord>> arrayList = new ArrayList<List<HasWord>>();
            for (List<HasWord> sentence : dp) {
                arrayList.add(sentence);
            }
            sentences = arrayList;
        } else {
            String[] sent = new String[]{"This", "is", "an", "easy", "sentence", "."};
            ArrayList<Word> arrayList = new ArrayList<Word>();
            for (String word : sent) {
                arrayList.add(new Word(word));
            }
            String sent2 = "This is a slightly longer and more complex sentence requiring tokenization.";
            Tokenizer<? extends HasWord> toke = tlp.getTokenizerFactory().getTokenizer(new StringReader(sent2));
            List<? extends HasWord> sentence2 = toke.tokenize();
            ArrayList<List<HasWord>> tmp = new ArrayList<List<HasWord>>();
            tmp.add(arrayList);
            tmp.add(sentence2);
            sentences = tmp;
        }
        for (List list : sentences) {
            Tree parse = lp.parse(list);
            parse.pennPrint();
            System.out.println();
            GrammaticalStructure gs = gsf.newGrammaticalStructure(parse);
            List<TypedDependency> tdl = gs.typedDependenciesCCprocessed();
            System.out.println(tdl);
            System.out.println();
            System.out.println("The words of the sentence:");
            for (Label lab : parse.yield()) {
                if (lab instanceof CoreLabel) {
                    System.out.println(((CoreLabel)lab).toString("{map}"));
                    continue;
                }
                System.out.println(lab);
            }
            System.out.println();
            System.out.println(parse.taggedYield());
            System.out.println();
        }
        String sent3 = "This is one last test!";
        lp.parse(sent3).pennPrint();
    }
}

