/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.math;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.util.StringUtils;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;

public class ArrayMath {
    private static final Random rand = new Random();

    private ArrayMath() {
    }

    public static int numRows(double[] v) {
        return v.length;
    }

    public static int[] range(int start, int end) {
        assert (end > start);
        int len = end - start;
        int[] range = new int[len];
        for (int i = 0; i < range.length; ++i) {
            range[i] = i + start;
        }
        return range;
    }

    public static float[] doubleArrayToFloatArray(double[] a) {
        float[] result = new float[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = (float)a[i];
        }
        return result;
    }

    public static double[] floatArrayToDoubleArray(float[] a) {
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i];
        }
        return result;
    }

    public static double[][] floatArrayToDoubleArray(float[][] a) {
        double[][] result = new double[a.length][];
        for (int i = 0; i < a.length; ++i) {
            result[i] = new double[a[i].length];
            for (int j = 0; j < a[i].length; ++j) {
                result[i][j] = a[i][j];
            }
        }
        return result;
    }

    public static float[][] doubleArrayToFloatArray(double[][] a) {
        float[][] result = new float[a.length][];
        for (int i = 0; i < a.length; ++i) {
            result[i] = new float[a[i].length];
            for (int j = 0; j < a[i].length; ++j) {
                result[i][j] = (float)a[i][j];
            }
        }
        return result;
    }

    public static double[] exp(double[] a) {
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = Math.exp(a[i]);
        }
        return result;
    }

    public static double[] log(double[] a) {
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = Math.log(a[i]);
        }
        return result;
    }

    public static void expInPlace(double[] a) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = Math.exp(a[i]);
        }
    }

    public static void logInPlace(double[] a) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = Math.log(a[i]);
        }
    }

    public static double[] softmax(double[] scales) {
        int i;
        double[] newScales = new double[scales.length];
        double sum = 0.0;
        for (i = 0; i < scales.length; ++i) {
            newScales[i] = Math.exp(scales[i]);
            sum += newScales[i];
        }
        i = 0;
        while (i < scales.length) {
            int n = i++;
            newScales[n] = newScales[n] / sum;
        }
        return newScales;
    }

    public static void addInPlace(double[] a, double b) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = a[i] + b;
        }
    }

    public static void addInPlace(float[] a, double b) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = (float)((double)a[i] + b);
        }
    }

    public static void addMultInPlace(double[] a, double[] b, double c) {
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            a[n] = a[n] + b[i] * c;
        }
    }

    public static void multiplyInPlace(double[] a, double b) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = a[i] * b;
        }
    }

    public static void multiplyInPlace(float[] a, double b) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = (float)((double)a[i] * b);
        }
    }

    public static void divideInPlace(double[] a, double b) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = a[i] / b;
        }
    }

    public static void powInPlace(double[] a, double c) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = Math.pow(a[i], c);
        }
    }

    public static void powInPlace(float[] a, float c) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = (float)Math.pow(a[i], c);
        }
    }

    public static double[] add(double[] a, double c) {
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i] + c;
        }
        return result;
    }

    public static float[] add(float[] a, double c) {
        float[] result = new float[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = (float)((double)a[i] + c);
        }
        return result;
    }

    public static double[] multiply(double[] a, double c) {
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i] * c;
        }
        return result;
    }

    public static float[] multiply(float[] a, float c) {
        float[] result = new float[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i] * c;
        }
        return result;
    }

    public static double[] pow(double[] a, double c) {
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = Math.pow(a[i], c);
        }
        return result;
    }

    public static float[] pow(float[] a, float c) {
        float[] result = new float[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = (float)Math.pow(a[i], c);
        }
        return result;
    }

    public static void pairwiseAddInPlace(double[] to, double[] from) {
        if (to.length != from.length) {
            throw new RuntimeException();
        }
        for (int i = 0; i < to.length; ++i) {
            to[i] = to[i] + from[i];
        }
    }

    public static void pairwiseAddInPlace(double[] to, int[] from) {
        if (to.length != from.length) {
            throw new RuntimeException();
        }
        for (int i = 0; i < to.length; ++i) {
            to[i] = to[i] + (double)from[i];
        }
    }

    public static void pairwiseAddInPlace(double[] to, short[] from) {
        if (to.length != from.length) {
            throw new RuntimeException();
        }
        for (int i = 0; i < to.length; ++i) {
            to[i] = to[i] + (double)from[i];
        }
    }

    public static void pairwiseSubtractInPlace(double[] to, double[] from) {
        if (to.length != from.length) {
            throw new RuntimeException();
        }
        for (int i = 0; i < to.length; ++i) {
            to[i] = to[i] - from[i];
        }
    }

    public static void pairwiseScaleAddInPlace(double[] to, double[] from, double fromScale) {
        if (to.length != from.length) {
            throw new RuntimeException();
        }
        for (int i = 0; i < to.length; ++i) {
            to[i] = to[i] + fromScale * from[i];
        }
    }

    public static int[] pairwiseAdd(int[] a, int[] b) {
        int[] result = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i] + b[i];
        }
        return result;
    }

    public static double[] pairwiseAdd(double[] a, double[] b) {
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = i < b.length ? a[i] + b[i] : a[i];
        }
        return result;
    }

    public static float[] pairwiseAdd(float[] a, float[] b) {
        float[] result = new float[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i] + b[i];
        }
        return result;
    }

    public static double[] pairwiseScaleAdd(double[] a, double[] b, double bScale) {
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i] + bScale * b[i];
        }
        return result;
    }

    public static double[] pairwiseSubtract(double[] a, double[] b) {
        double[] c = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            c[i] = a[i] - b[i];
        }
        return c;
    }

    public static float[] pairwiseSubtract(float[] a, float[] b) {
        float[] c = new float[a.length];
        for (int i = 0; i < a.length; ++i) {
            c[i] = a[i] - b[i];
        }
        return c;
    }

    public static double[] pairwiseMultiply(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new RuntimeException("Can't pairwise multiple different lengths: a.length=" + a.length + " b.length=" + b.length);
        }
        double[] result = new double[a.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = a[i] * b[i];
        }
        return result;
    }

    public static float[] pairwiseMultiply(float[] a, float[] b) {
        if (a.length != b.length) {
            throw new RuntimeException();
        }
        float[] result = new float[a.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = a[i] * b[i];
        }
        return result;
    }

    public static void pairwiseMultiply(double[] a, double[] b, double[] result) {
        if (a.length != b.length) {
            throw new RuntimeException();
        }
        for (int i = 0; i < result.length; ++i) {
            result[i] = a[i] * b[i];
        }
    }

    public static void pairwiseMultiply(float[] a, float[] b, float[] result) {
        if (a.length != b.length) {
            throw new RuntimeException();
        }
        for (int i = 0; i < result.length; ++i) {
            result[i] = a[i] * b[i];
        }
    }

    public static void pairwiseDivideInPlace(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new RuntimeException();
        }
        for (int i = 0; i < a.length; ++i) {
            a[i] = a[i] / b[i];
        }
    }

    public static boolean hasNaN(double[] a) {
        for (double x : a) {
            if (!Double.isNaN(x)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasInfinite(double[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (!Double.isInfinite(a[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNaN(float[] a) {
        for (float x : a) {
            if (!Float.isNaN(x)) continue;
            return true;
        }
        return false;
    }

    public static int countNaN(double[] v) {
        int c = 0;
        for (double d : v) {
            if (!Double.isNaN(d)) continue;
            ++c;
        }
        return c;
    }

    public static double[] filterNaN(double[] v) {
        double[] u = new double[ArrayMath.numRows(v) - ArrayMath.countNaN(v)];
        int j = 0;
        for (double d : v) {
            if (Double.isNaN(d)) continue;
            u[j++] = d;
        }
        return u;
    }

    public static int countInfinite(double[] v) {
        int c = 0;
        for (int i = 0; i < v.length; ++i) {
            if (!Double.isInfinite(v[i])) continue;
            ++c;
        }
        return c;
    }

    public static int countNonZero(double[] v) {
        int c = 0;
        for (int i = 0; i < v.length; ++i) {
            if (v[i] == 0.0) continue;
            ++c;
        }
        return c;
    }

    public static int countCloseToZero(double[] v, double epsilon) {
        int c = 0;
        for (int i = 0; i < v.length; ++i) {
            if (!(Math.abs(v[i]) < epsilon)) continue;
            ++c;
        }
        return c;
    }

    public static int countPositive(double[] v) {
        int c = 0;
        for (double a : v) {
            if (!(a > 0.0)) continue;
            ++c;
        }
        return c;
    }

    public static int countNegative(double[] v) {
        int c = 0;
        for (int i = 0; i < v.length; ++i) {
            if (!(v[i] < 0.0)) continue;
            ++c;
        }
        return c;
    }

    public static double[] filterInfinite(double[] v) {
        double[] u = new double[ArrayMath.numRows(v) - ArrayMath.countInfinite(v)];
        int j = 0;
        for (int i = 0; i < v.length; ++i) {
            if (Double.isInfinite(v[i])) continue;
            u[j++] = v[i];
        }
        return u;
    }

    public static double[] filterNaNAndInfinite(double[] v) {
        return ArrayMath.filterInfinite(ArrayMath.filterNaN(v));
    }

    public static double sum(double[] a) {
        return ArrayMath.sum(a, 0, a.length);
    }

    public static double sum(double[] a, int fromIndex, int toIndex) {
        double result = 0.0;
        for (int i = fromIndex; i < toIndex; ++i) {
            result += a[i];
        }
        return result;
    }

    public static int sum(int[] a) {
        int result = 0;
        for (int i : a) {
            result += i;
        }
        return result;
    }

    public static float sum(float[] a) {
        float result = 0.0f;
        for (float f : a) {
            result += f;
        }
        return result;
    }

    public static int sum(int[][] a) {
        int result = 0;
        int[][] arr$ = a;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int[] v;
            for (int item : v = arr$[i$]) {
                result += item;
            }
        }
        return result;
    }

    public static int[] diag(int[][] a) {
        int[] rv = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            rv[i] = a[i][i];
        }
        return rv;
    }

    public static double average(double[] a) {
        double total = ArrayMath.sum(a);
        return total / (double)a.length;
    }

    public static double norm_inf(double[] a) {
        double max = Double.NEGATIVE_INFINITY;
        for (double d : a) {
            if (!(Math.abs(d) > max)) continue;
            max = Math.abs(d);
        }
        return max;
    }

    public static double norm_inf(float[] a) {
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < a.length; ++i) {
            if (!((double)Math.abs(a[i]) > max)) continue;
            max = Math.abs(a[i]);
        }
        return max;
    }

    public static double norm_1(double[] a) {
        double sum = 0.0;
        for (double anA : a) {
            sum += anA < 0.0 ? -anA : anA;
        }
        return sum;
    }

    public static double norm_1(float[] a) {
        double sum = 0.0;
        for (float anA : a) {
            sum += (double)(anA < 0.0f ? -anA : anA);
        }
        return sum;
    }

    public static double norm(double[] a) {
        double squaredSum = 0.0;
        for (double anA : a) {
            squaredSum += anA * anA;
        }
        return Math.sqrt(squaredSum);
    }

    public static double norm(float[] a) {
        double squaredSum = 0.0;
        for (float anA : a) {
            squaredSum += (double)(anA * anA);
        }
        return Math.sqrt(squaredSum);
    }

    public static int argmax(double[] a) {
        double max = Double.NEGATIVE_INFINITY;
        int argmax = 0;
        for (int i = 0; i < a.length; ++i) {
            if (!(a[i] > max)) continue;
            max = a[i];
            argmax = i;
        }
        return argmax;
    }

    public static int argmax_tieLast(double[] a) {
        double max = Double.NEGATIVE_INFINITY;
        int argmax = 0;
        for (int i = 0; i < a.length; ++i) {
            if (!(a[i] >= max)) continue;
            max = a[i];
            argmax = i;
        }
        return argmax;
    }

    public static double max(double[] a) {
        return a[ArrayMath.argmax(a)];
    }

    public static double max(Collection<Double> a) {
        double max = Double.NEGATIVE_INFINITY;
        for (double d : a) {
            if (!(d > max)) continue;
            max = d;
        }
        return max;
    }

    public static int argmax(float[] a) {
        float max = Float.NEGATIVE_INFINITY;
        int argmax = 0;
        for (int i = 0; i < a.length; ++i) {
            if (!(a[i] > max)) continue;
            max = a[i];
            argmax = i;
        }
        return argmax;
    }

    public static float max(float[] a) {
        return a[ArrayMath.argmax(a)];
    }

    public static int argmin(double[] a) {
        double min = Double.POSITIVE_INFINITY;
        int argmin = 0;
        for (int i = 0; i < a.length; ++i) {
            if (!(a[i] < min)) continue;
            min = a[i];
            argmin = i;
        }
        return argmin;
    }

    public static double min(double[] a) {
        return a[ArrayMath.argmin(a)];
    }

    public static double safeMin(double[] v) {
        double[] u = ArrayMath.filterNaNAndInfinite(v);
        if (ArrayMath.numRows(u) == 0) {
            return 0.0;
        }
        return ArrayMath.min(u);
    }

    public static int argmin(float[] a) {
        float min = Float.POSITIVE_INFINITY;
        int argmin = 0;
        for (int i = 0; i < a.length; ++i) {
            if (!(a[i] < min)) continue;
            min = a[i];
            argmin = i;
        }
        return argmin;
    }

    public static float min(float[] a) {
        return a[ArrayMath.argmin(a)];
    }

    public static int argmin(int[] a) {
        int min = Integer.MAX_VALUE;
        int argmin = 0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] >= min) continue;
            min = a[i];
            argmin = i;
        }
        return argmin;
    }

    public static int min(int[] a) {
        return a[ArrayMath.argmin(a)];
    }

    public static int argmax(int[] a) {
        int max = Integer.MIN_VALUE;
        int argmax = 0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] <= max) continue;
            max = a[i];
            argmax = i;
        }
        return argmax;
    }

    public static int max(int[] a) {
        return a[ArrayMath.argmax(a)];
    }

    public static int min(int[][] matrix) {
        int min = Integer.MAX_VALUE;
        int[][] arr$ = matrix;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int[] row;
            for (int elem : row = arr$[i$]) {
                min = Math.min(min, elem);
            }
        }
        return min;
    }

    public static int max(int[][] matrix) {
        int max = Integer.MIN_VALUE;
        int[][] arr$ = matrix;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int[] row;
            for (int elem : row = arr$[i$]) {
                max = Math.max(max, elem);
            }
        }
        return max;
    }

    public static double safeMax(double[] v) {
        double[] u = ArrayMath.filterNaNAndInfinite(v);
        if (ArrayMath.numRows(u) == 0) {
            return 0.0;
        }
        return ArrayMath.max(u);
    }

    public static double logSum(double ... logInputs) {
        return ArrayMath.logSum(logInputs, 0, logInputs.length);
    }

    public static double logSum(double[] logInputs, int fromIndex, int toIndex) {
        if (logInputs.length == 0) {
            throw new IllegalArgumentException();
        }
        if (fromIndex >= 0 && toIndex < logInputs.length && fromIndex >= toIndex) {
            return Double.NEGATIVE_INFINITY;
        }
        int maxIdx = fromIndex;
        double max = logInputs[fromIndex];
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            if (!(logInputs[i] > max)) continue;
            maxIdx = i;
            max = logInputs[i];
        }
        boolean haveTerms = false;
        double intermediate = 0.0;
        double cutoff = max - 30.0;
        for (int i = fromIndex; i < toIndex; ++i) {
            if (i == maxIdx || !(logInputs[i] > cutoff)) continue;
            haveTerms = true;
            intermediate += Math.exp(logInputs[i] - max);
        }
        if (haveTerms) {
            return max + Math.log(1.0 + intermediate);
        }
        return max;
    }

    public static double logSum(double[] logInputs, int fromIndex, int afterIndex, int stride) {
        if (logInputs.length == 0) {
            throw new IllegalArgumentException();
        }
        if (fromIndex >= 0 && afterIndex < logInputs.length && fromIndex >= afterIndex) {
            return Double.NEGATIVE_INFINITY;
        }
        int maxIdx = fromIndex;
        double max = logInputs[fromIndex];
        for (int i = fromIndex + stride; i < afterIndex; i += stride) {
            if (!(logInputs[i] > max)) continue;
            maxIdx = i;
            max = logInputs[i];
        }
        boolean haveTerms = false;
        double intermediate = 0.0;
        double cutoff = max - 30.0;
        for (int i = fromIndex; i < afterIndex; i += stride) {
            if (i == maxIdx || !(logInputs[i] > cutoff)) continue;
            haveTerms = true;
            intermediate += Math.exp(logInputs[i] - max);
        }
        if (haveTerms) {
            return max + Math.log(1.0 + intermediate);
        }
        return max;
    }

    public static double logSum(List<Double> logInputs) {
        return ArrayMath.logSum(logInputs, 0, logInputs.size());
    }

    public static double logSum(List<Double> logInputs, int fromIndex, int toIndex) {
        int length = logInputs.size();
        if (length == 0) {
            throw new IllegalArgumentException();
        }
        if (fromIndex >= 0 && toIndex < length && fromIndex >= toIndex) {
            return Double.NEGATIVE_INFINITY;
        }
        int maxIdx = fromIndex;
        double max = logInputs.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            double d = logInputs.get(i);
            if (!(d > max)) continue;
            maxIdx = i;
            max = d;
        }
        boolean haveTerms = false;
        double intermediate = 0.0;
        double cutoff = max - 30.0;
        for (int i = fromIndex; i < toIndex; ++i) {
            double d = logInputs.get(i);
            if (i == maxIdx || !(d > cutoff)) continue;
            haveTerms = true;
            intermediate += Math.exp(d - max);
        }
        if (haveTerms) {
            return max + Math.log(1.0 + intermediate);
        }
        return max;
    }

    public static float logSum(float[] logInputs) {
        int leng = logInputs.length;
        if (leng == 0) {
            throw new IllegalArgumentException();
        }
        int maxIdx = 0;
        float max = logInputs[0];
        for (int i = 1; i < leng; ++i) {
            if (!(logInputs[i] > max)) continue;
            maxIdx = i;
            max = logInputs[i];
        }
        boolean haveTerms = false;
        double intermediate = 0.0;
        float cutoff = max - 20.0f;
        for (int i = 0; i < leng; ++i) {
            if (i == maxIdx || !(logInputs[i] > cutoff)) continue;
            haveTerms = true;
            intermediate += Math.exp(logInputs[i] - max);
        }
        if (haveTerms) {
            return max + (float)Math.log(1.0 + intermediate);
        }
        return max;
    }

    public static double innerProduct(double[] a, double[] b) {
        double result = 0.0;
        int len = Math.min(a.length, b.length);
        for (int i = 0; i < len; ++i) {
            result += a[i] * b[i];
        }
        return result;
    }

    public static double innerProduct(float[] a, float[] b) {
        double result = 0.0;
        int len = Math.min(a.length, b.length);
        for (int i = 0; i < len; ++i) {
            result += (double)(a[i] * b[i]);
        }
        return result;
    }

    public static int[] subArray(int[] a, int from, int to) {
        int[] result = new int[to - from];
        System.arraycopy(a, from, result, 0, to - from);
        return result;
    }

    public static double[][] load2DMatrixFromFile(String filename) throws IOException {
        String s = IOUtils.slurpFile(filename);
        String[] rows = s.split("[\r\n]+");
        double[][] result = new double[rows.length][];
        for (int i = 0; i < result.length; ++i) {
            String[] columns = rows[i].split("\\s+");
            result[i] = new double[columns.length];
            for (int j = 0; j < result[i].length; ++j) {
                result[i][j] = Double.parseDouble(columns[j]);
            }
        }
        return result;
    }

    public static Integer[] box(int[] assignment) {
        Integer[] result = new Integer[assignment.length];
        for (int i = 0; i < assignment.length; ++i) {
            result[i] = assignment[i];
        }
        return result;
    }

    public static int[] unboxToInt(Collection<Integer> list) {
        int[] result = new int[list.size()];
        int i = 0;
        for (int v : list) {
            result[i++] = v;
        }
        return result;
    }

    public static Double[] box(double[] assignment) {
        Double[] result = new Double[assignment.length];
        for (int i = 0; i < assignment.length; ++i) {
            result[i] = assignment[i];
        }
        return result;
    }

    public static double[] unbox(Collection<Double> list) {
        double[] result = new double[list.size()];
        int i = 0;
        for (double v : list) {
            result[i++] = v;
        }
        return result;
    }

    public static int indexOf(int n, int[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != n) continue;
            return i;
        }
        return -1;
    }

    public static int[][] castToInt(double[][] doubleCounts) {
        int[][] result = new int[doubleCounts.length][];
        for (int i = 0; i < doubleCounts.length; ++i) {
            result[i] = new int[doubleCounts[i].length];
            for (int j = 0; j < doubleCounts[i].length; ++j) {
                result[i][j] = (int)doubleCounts[i][j];
            }
        }
        return result;
    }

    public static void normalize(double[] a) {
        double total = ArrayMath.sum(a);
        if (total == 0.0 || Double.isNaN(total)) {
            throw new RuntimeException("Can't normalize an array with sum 0.0 or NaN: " + Arrays.toString(a));
        }
        ArrayMath.multiplyInPlace(a, 1.0 / total);
    }

    public static void L1normalize(double[] a) {
        double total = ArrayMath.L1Norm(a);
        if (total == 0.0 || Double.isNaN(total)) {
            if (a.length < 100) {
                throw new RuntimeException("Can't normalize an array with sum 0.0 or NaN: " + Arrays.toString(a));
            }
            double[] aTrunc = new double[100];
            System.arraycopy(a, 0, aTrunc, 0, 100);
            throw new RuntimeException("Can't normalize an array with sum 0.0 or NaN: " + Arrays.toString(aTrunc) + " ... ");
        }
        ArrayMath.multiplyInPlace(a, 1.0 / total);
    }

    public static void normalize(float[] a) {
        float total = ArrayMath.sum(a);
        if (total == 0.0f || Double.isNaN(total)) {
            throw new RuntimeException("Can't normalize an array with sum 0.0 or NaN");
        }
        ArrayMath.multiplyInPlace(a, (double)(1.0f / total));
    }

    public static void standardize(double[] a) {
        double m = ArrayMath.mean(a);
        if (Double.isNaN(m)) {
            throw new RuntimeException("Can't standardize array whose mean is NaN");
        }
        double s = ArrayMath.stdev(a);
        if (s == 0.0 || Double.isNaN(s)) {
            throw new RuntimeException("Can't standardize array whose standard deviation is 0.0 or NaN");
        }
        ArrayMath.addInPlace(a, -m);
        ArrayMath.multiplyInPlace(a, 1.0 / s);
    }

    public static double L2Norm(double[] a) {
        double result = 0.0;
        for (double d : a) {
            result += Math.pow(d, 2.0);
        }
        return Math.sqrt(result);
    }

    public static double L1Norm(double[] a) {
        double result = 0.0;
        for (double d : a) {
            result += Math.abs(d);
        }
        return result;
    }

    public static void logNormalize(double[] a) {
        double logTotal = ArrayMath.logSum(a);
        if (logTotal == Double.NEGATIVE_INFINITY) {
            double v = -Math.log(a.length);
            for (int i = 0; i < a.length; ++i) {
                a[i] = v;
            }
            return;
        }
        ArrayMath.addInPlace(a, -logTotal);
    }

    public static int sampleFromDistribution(double[] d) {
        return ArrayMath.sampleFromDistribution(d, rand);
    }

    public static int sampleFromDistribution(double[] d, Random random) {
        double r = random.nextDouble();
        double total = 0.0;
        for (int i = 0; i < d.length - 1; ++i) {
            if (Double.isNaN(d[i])) {
                throw new RuntimeException("Can't sample from NaN");
            }
            if (!(r < (total += d[i]))) continue;
            return i;
        }
        return d.length - 1;
    }

    public static int sampleFromDistribution(float[] d, Random random) {
        double r = random.nextDouble();
        double total = 0.0;
        for (int i = 0; i < d.length - 1; ++i) {
            if (Float.isNaN(d[i])) {
                throw new RuntimeException("Can't sample from NaN");
            }
            if (!(r < (total += (double)d[i]))) continue;
            return i;
        }
        return d.length - 1;
    }

    public static double klDivergence(double[] from, double[] to) {
        double kl = 0.0;
        double tot = ArrayMath.sum(from);
        double tot2 = ArrayMath.sum(to);
        for (int i = 0; i < from.length; ++i) {
            if (from[i] == 0.0) continue;
            double num = from[i] / tot;
            double num2 = to[i] / tot2;
            kl += num * (Math.log(num / num2) / Math.log(2.0));
        }
        return kl;
    }

    public static double jensenShannonDivergence(double[] a, double[] b) {
        double[] average = ArrayMath.pairwiseAdd(a, b);
        ArrayMath.multiplyInPlace(average, 0.5);
        return 0.5 * ArrayMath.klDivergence(a, average) + 0.5 * ArrayMath.klDivergence(b, average);
    }

    public static void setToLogDeterministic(float[] a, int i) {
        for (int j = 0; j < a.length; ++j) {
            a[j] = j == i ? 0.0f : Float.NEGATIVE_INFINITY;
        }
    }

    public static void setToLogDeterministic(double[] a, int i) {
        for (int j = 0; j < a.length; ++j) {
            a[j] = j == i ? 0.0 : Double.NEGATIVE_INFINITY;
        }
    }

    public static double mean(double[] a) {
        return ArrayMath.sum(a) / (double)a.length;
    }

    public static double median(double[] a) {
        double[] b = new double[a.length];
        System.arraycopy(a, 0, b, 0, b.length);
        Arrays.sort(b);
        int mid = b.length / 2;
        if (b.length % 2 == 0) {
            return (b[mid - 1] + b[mid]) / 2.0;
        }
        return b[mid];
    }

    public static double safeMean(double[] v) {
        double[] u = ArrayMath.filterNaNAndInfinite(v);
        if (ArrayMath.numRows(u) == 0) {
            return 0.0;
        }
        return ArrayMath.mean(u);
    }

    public static double sumSquaredError(double[] a) {
        double mean = ArrayMath.mean(a);
        double result = 0.0;
        for (double anA : a) {
            double diff = anA - mean;
            result += diff * diff;
        }
        return result;
    }

    public static double sumSquared(double[] a) {
        double result = 0.0;
        for (double anA : a) {
            result += anA * anA;
        }
        return result;
    }

    public static double variance(double[] a) {
        return ArrayMath.sumSquaredError(a) / (double)(a.length - 1);
    }

    public static double stdev(double[] a) {
        return Math.sqrt(ArrayMath.variance(a));
    }

    public static double safeStdev(double[] v) {
        double[] u = ArrayMath.filterNaNAndInfinite(v);
        if (ArrayMath.numRows(u) < 2) {
            return 1.0;
        }
        return ArrayMath.stdev(u);
    }

    public static double standardErrorOfMean(double[] a) {
        return ArrayMath.stdev(a) / Math.sqrt(a.length);
    }

    public static void sampleWithoutReplacement(int[] array, int numArgClasses) {
        ArrayMath.sampleWithoutReplacement(array, numArgClasses, rand);
    }

    public static void sampleWithoutReplacement(int[] array, int numArgClasses, Random rand) {
        int[] temp = new int[numArgClasses];
        for (int i = 0; i < temp.length; ++i) {
            temp[i] = i;
        }
        ArrayMath.shuffle(temp, rand);
        System.arraycopy(temp, 0, array, 0, array.length);
    }

    public static void shuffle(int[] a) {
        ArrayMath.shuffle(a, rand);
    }

    public static void shuffle(int[] a, Random rand) {
        for (int i = a.length - 1; i > 0; --i) {
            int j = rand.nextInt(i + 1);
            int tmp = a[i];
            a[i] = a[j];
            a[j] = tmp;
        }
    }

    public static void reverse(int[] a) {
        for (int i = 0; i < a.length / 2; ++i) {
            int j = a.length - i - 1;
            int tmp = a[i];
            a[i] = a[j];
            a[j] = tmp;
        }
    }

    public static boolean contains(int[] a, int i) {
        for (int k : a) {
            if (k != i) continue;
            return true;
        }
        return false;
    }

    public static boolean containsInSubarray(int[] a, int begin, int end, int i) {
        for (int j = begin; j < end; ++j) {
            if (a[j] != i) continue;
            return true;
        }
        return false;
    }

    public static double pearsonCorrelation(double[] x, double[] y) {
        double sum_sq_x = 0.0;
        double sum_sq_y = 0.0;
        double mean_x = x[0];
        double mean_y = y[0];
        double sum_coproduct = 0.0;
        for (int i = 2; i < x.length + 1; ++i) {
            double w = (double)(i - 1) * 1.0 / (double)i;
            double delta_x = x[i - 1] - mean_x;
            double delta_y = y[i - 1] - mean_y;
            sum_sq_x += delta_x * delta_x * w;
            sum_sq_y += delta_y * delta_y * w;
            sum_coproduct += delta_x * delta_y * w;
            mean_x += delta_x / (double)i;
            mean_y += delta_y / (double)i;
        }
        double pop_sd_x = Math.sqrt(sum_sq_x / (double)x.length);
        double pop_sd_y = Math.sqrt(sum_sq_y / (double)y.length);
        double cov_x_y = sum_coproduct / (double)x.length;
        double denom = pop_sd_x * pop_sd_y;
        if (denom == 0.0) {
            return 0.0;
        }
        double result = cov_x_y / denom;
        return result;
    }

    public static double sigLevelByApproxRand(double[] A, double[] B) {
        return ArrayMath.sigLevelByApproxRand(A, B, 1000);
    }

    public static double sigLevelByApproxRand(double[] A, double[] B, int iterations) {
        if (A.length == 0) {
            throw new IllegalArgumentException("Input arrays must not be empty!");
        }
        if (A.length != B.length) {
            throw new IllegalArgumentException("Input arrays must have equal length!");
        }
        if (iterations <= 0) {
            throw new IllegalArgumentException("Number of iterations must be positive!");
        }
        double testStatistic = ArrayMath.absDiffOfMeans(A, B, false);
        int successes = 0;
        for (int i = 0; i < iterations; ++i) {
            double t = ArrayMath.absDiffOfMeans(A, B, true);
            if (!(t >= testStatistic)) continue;
            ++successes;
        }
        return (double)(successes + 1) / (double)(iterations + 1);
    }

    public static double sigLevelByApproxRand(int[] A, int[] B) {
        return ArrayMath.sigLevelByApproxRand(A, B, 1000);
    }

    public static double sigLevelByApproxRand(int[] A, int[] B, int iterations) {
        if (A.length == 0) {
            throw new IllegalArgumentException("Input arrays must not be empty!");
        }
        if (A.length != B.length) {
            throw new IllegalArgumentException("Input arrays must have equal length!");
        }
        if (iterations <= 0) {
            throw new IllegalArgumentException("Number of iterations must be positive!");
        }
        double[] X = new double[A.length];
        double[] Y = new double[B.length];
        for (int i = 0; i < A.length; ++i) {
            X[i] = A[i];
            Y[i] = B[i];
        }
        return ArrayMath.sigLevelByApproxRand(X, Y, iterations);
    }

    public static double sigLevelByApproxRand(boolean[] A, boolean[] B) {
        return ArrayMath.sigLevelByApproxRand(A, B, 1000);
    }

    public static double sigLevelByApproxRand(boolean[] A, boolean[] B, int iterations) {
        if (A.length == 0) {
            throw new IllegalArgumentException("Input arrays must not be empty!");
        }
        if (A.length != B.length) {
            throw new IllegalArgumentException("Input arrays must have equal length!");
        }
        if (iterations <= 0) {
            throw new IllegalArgumentException("Number of iterations must be positive!");
        }
        double[] X = new double[A.length];
        double[] Y = new double[B.length];
        for (int i = 0; i < A.length; ++i) {
            X[i] = A[i] ? 1.0 : 0.0;
            Y[i] = B[i] ? 1.0 : 0.0;
        }
        return ArrayMath.sigLevelByApproxRand(X, Y, iterations);
    }

    private static double absDiffOfMeans(double[] A, double[] B, boolean randomize) {
        Random random = new Random();
        double aTotal = 0.0;
        double bTotal = 0.0;
        for (int i = 0; i < A.length; ++i) {
            if (randomize && random.nextBoolean()) {
                aTotal += B[i];
                bTotal += A[i];
                continue;
            }
            aTotal += A[i];
            bTotal += B[i];
        }
        double aMean = aTotal / (double)A.length;
        double bMean = bTotal / (double)B.length;
        return Math.abs(aMean - bMean);
    }

    public static String toBinaryString(byte[] b) {
        StringBuilder s = new StringBuilder();
        for (byte by : b) {
            for (int j = 7; j >= 0; --j) {
                if ((by & 1 << j) > 0) {
                    s.append('1');
                    continue;
                }
                s.append('0');
            }
            s.append(' ');
        }
        return s.toString();
    }

    public static String toString(double[] a) {
        return ArrayMath.toString(a, null);
    }

    public static String toString(double[] a, NumberFormat nf) {
        if (a == null) {
            return null;
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        for (int i = 0; i < a.length - 1; ++i) {
            String s = nf == null ? String.valueOf(a[i]) : nf.format(a[i]);
            b.append(s);
            b.append(", ");
        }
        String s = nf == null ? String.valueOf(a[a.length - 1]) : nf.format(a[a.length - 1]);
        b.append(s);
        b.append(']');
        return b.toString();
    }

    public static String toString(float[] a) {
        return ArrayMath.toString(a, null);
    }

    public static String toString(float[] a, NumberFormat nf) {
        if (a == null) {
            return null;
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        for (int i = 0; i < a.length - 1; ++i) {
            String s = nf == null ? String.valueOf(a[i]) : nf.format(a[i]);
            b.append(s);
            b.append(", ");
        }
        String s = nf == null ? String.valueOf(a[a.length - 1]) : nf.format(a[a.length - 1]);
        b.append(s);
        b.append(']');
        return b.toString();
    }

    public static String toString(int[] a) {
        return ArrayMath.toString(a, null);
    }

    public static String toString(int[] a, NumberFormat nf) {
        if (a == null) {
            return null;
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        for (int i = 0; i < a.length - 1; ++i) {
            String s = nf == null ? String.valueOf(a[i]) : nf.format(a[i]);
            b.append(s);
            b.append(", ");
        }
        String s = nf == null ? String.valueOf(a[a.length - 1]) : nf.format(a[a.length - 1]);
        b.append(s);
        b.append(']');
        return b.toString();
    }

    public static String toString(byte[] a) {
        return ArrayMath.toString(a, null);
    }

    public static String toString(byte[] a, NumberFormat nf) {
        if (a == null) {
            return null;
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        for (int i = 0; i < a.length - 1; ++i) {
            String s = nf == null ? String.valueOf(a[i]) : nf.format(a[i]);
            b.append(s);
            b.append(", ");
        }
        String s = nf == null ? String.valueOf(a[a.length - 1]) : nf.format(a[a.length - 1]);
        b.append(s);
        b.append(']');
        return b.toString();
    }

    public static String toString(int[][] counts) {
        return ArrayMath.toString(counts, null, null, 10, 10, NumberFormat.getInstance(), false);
    }

    public static String toString(int[][] counts, Object[] rowLabels, Object[] colLabels, int labelSize, int cellSize, NumberFormat nf, boolean printTotals) {
        int j;
        if (counts.length == 0 || counts[0].length == 0) {
            return "";
        }
        int[] rowTotals = new int[counts.length];
        int[] colTotals = new int[counts[0].length];
        int total = 0;
        for (int i = 0; i < counts.length; ++i) {
            for (j = 0; j < counts[i].length; ++j) {
                int n = i;
                rowTotals[n] = rowTotals[n] + counts[i][j];
                int n2 = j;
                colTotals[n2] = colTotals[n2] + counts[i][j];
                total += counts[i][j];
            }
        }
        StringBuilder result = new StringBuilder();
        if (colLabels != null) {
            result.append(StringUtils.padLeft("", labelSize));
            for (j = 0; j < counts[0].length; ++j) {
                String s;
                String string = s = colLabels[j] == null ? "null" : colLabels[j].toString();
                if (s.length() > cellSize - 1) {
                    s = s.substring(0, cellSize - 1);
                }
                s = StringUtils.padLeft(s, cellSize);
                result.append(s);
            }
            if (printTotals) {
                result.append(StringUtils.padLeftOrTrim("Total", cellSize));
            }
            result.append('\n');
        }
        for (int i = 0; i < counts.length; ++i) {
            if (rowLabels != null) {
                String s = rowLabels[i] == null ? "null" : rowLabels[i].toString();
                s = StringUtils.padOrTrim(s, labelSize);
                result.append(s);
            }
            for (int j2 = 0; j2 < counts[i].length; ++j2) {
                result.append(StringUtils.padLeft(nf.format(counts[i][j2]), cellSize));
            }
            if (printTotals) {
                result.append(StringUtils.padLeft(nf.format(rowTotals[i]), cellSize));
            }
            result.append('\n');
        }
        if (printTotals) {
            result.append(StringUtils.pad("Total", labelSize));
            for (int colTotal : colTotals) {
                result.append(StringUtils.padLeft(nf.format(colTotal), cellSize));
            }
            result.append(StringUtils.padLeft(nf.format(total), cellSize));
        }
        return result.toString();
    }

    public static String toString(double[][] counts) {
        return ArrayMath.toString(counts, 10, null, null, NumberFormat.getInstance(), false);
    }

    public static String toString(double[][] counts, int cellSize, Object[] rowLabels, Object[] colLabels, NumberFormat nf, boolean printTotals) {
        int j;
        if (counts == null) {
            return null;
        }
        double[] rowTotals = new double[counts.length];
        double[] colTotals = new double[counts[0].length];
        double total = 0.0;
        for (int i = 0; i < counts.length; ++i) {
            for (j = 0; j < counts[i].length; ++j) {
                int n = i;
                rowTotals[n] = rowTotals[n] + counts[i][j];
                int n2 = j;
                colTotals[n2] = colTotals[n2] + counts[i][j];
                total += counts[i][j];
            }
        }
        StringBuilder result = new StringBuilder();
        if (colLabels != null) {
            result.append(StringUtils.padLeft("", cellSize));
            for (j = 0; j < counts[0].length; ++j) {
                String s = colLabels[j].toString();
                if (s.length() > cellSize - 1) {
                    s = s.substring(0, cellSize - 1);
                }
                s = StringUtils.padLeft(s, cellSize);
                result.append(s);
            }
            if (printTotals) {
                result.append(StringUtils.padLeftOrTrim("Total", cellSize));
            }
            result.append('\n');
        }
        for (int i = 0; i < counts.length; ++i) {
            if (rowLabels != null) {
                String s = rowLabels[i].toString();
                s = StringUtils.padOrTrim(s, cellSize);
                result.append(s);
            }
            for (int j2 = 0; j2 < counts[i].length; ++j2) {
                result.append(StringUtils.padLeft(nf.format(counts[i][j2]), cellSize));
            }
            if (printTotals) {
                result.append(StringUtils.padLeft(nf.format(rowTotals[i]), cellSize));
            }
            result.append('\n');
        }
        if (printTotals) {
            result.append(StringUtils.pad("Total", cellSize));
            for (double colTotal : colTotals) {
                result.append(StringUtils.padLeft(nf.format(colTotal), cellSize));
            }
            result.append(StringUtils.padLeft(nf.format(total), cellSize));
        }
        return result.toString();
    }

    public static String toString(float[][] counts) {
        return ArrayMath.toString(counts, 10, null, null, NumberFormat.getIntegerInstance(), false);
    }

    public static String toString(float[][] counts, int cellSize, Object[] rowLabels, Object[] colLabels, NumberFormat nf, boolean printTotals) {
        int j;
        double[] rowTotals = new double[counts.length];
        double[] colTotals = new double[counts[0].length];
        double total = 0.0;
        for (int i = 0; i < counts.length; ++i) {
            for (j = 0; j < counts[i].length; ++j) {
                int n = i;
                rowTotals[n] = rowTotals[n] + (double)counts[i][j];
                int n2 = j;
                colTotals[n2] = colTotals[n2] + (double)counts[i][j];
                total += (double)counts[i][j];
            }
        }
        StringBuilder result = new StringBuilder();
        if (colLabels != null) {
            result.append(StringUtils.padLeft("", cellSize));
            for (j = 0; j < counts[0].length; ++j) {
                String s = colLabels[j].toString();
                s = StringUtils.padLeftOrTrim(s, cellSize);
                result.append(s);
            }
            if (printTotals) {
                result.append(StringUtils.padLeftOrTrim("Total", cellSize));
            }
            result.append('\n');
        }
        for (int i = 0; i < counts.length; ++i) {
            if (rowLabels != null) {
                String s = rowLabels[i].toString();
                s = StringUtils.pad(s, cellSize);
                result.append(s);
            }
            for (int j2 = 0; j2 < counts[i].length; ++j2) {
                result.append(StringUtils.padLeft(nf.format(counts[i][j2]), cellSize));
            }
            if (printTotals) {
                result.append(StringUtils.padLeft(nf.format(rowTotals[i]), cellSize));
            }
            result.append('\n');
        }
        if (printTotals) {
            result.append(StringUtils.pad("Total", cellSize));
            for (double colTotal : colTotals) {
                result.append(StringUtils.padLeft(nf.format(colTotal), cellSize));
            }
            result.append(StringUtils.padLeft(nf.format(total), cellSize));
        }
        return result.toString();
    }

    public static void main(String[] args) {
        Random random = new Random();
        int length = 100;
        double[] A = new double[length];
        double[] B = new double[length];
        double aAvg = 70.0;
        double bAvg = 70.5;
        for (int i = 0; i < length; ++i) {
            A[i] = aAvg + random.nextGaussian();
            B[i] = bAvg + random.nextGaussian();
        }
        System.out.println("A has length " + A.length + " and mean " + ArrayMath.mean(A));
        System.out.println("B has length " + B.length + " and mean " + ArrayMath.mean(B));
        for (int t = 0; t < 10; ++t) {
            System.out.println("p-value: " + ArrayMath.sigLevelByApproxRand(A, B));
        }
    }

    public static int[][] deepCopy(int[][] counts) {
        int[][] result = new int[counts.length][];
        for (int i = 0; i < counts.length; ++i) {
            result[i] = new int[counts[i].length];
            System.arraycopy(counts[i], 0, result[i], 0, counts[i].length);
        }
        return result;
    }

    public static double[][] covariance(double[][] data) {
        int j;
        int i;
        double[] means = new double[data.length];
        for (int i2 = 0; i2 < means.length; ++i2) {
            means[i2] = ArrayMath.mean(data[i2]);
        }
        double[][] covariance = new double[means.length][means.length];
        for (i = 0; i < data[0].length; ++i) {
            for (j = 0; j < means.length; ++j) {
                for (int k = 0; k < means.length; ++k) {
                    double[] dArray = covariance[j];
                    int n = k;
                    dArray[n] = dArray[n] + (means[j] - data[j][i]) * (means[k] - data[k][i]);
                }
            }
        }
        for (i = 0; i < covariance.length; ++i) {
            for (j = 0; j < covariance[i].length; ++j) {
                covariance[i][j] = Math.sqrt(covariance[i][j]) / (double)data[0].length;
            }
        }
        return covariance;
    }

    public static void addMultInto(double[] a, double[] b, double[] c, double d) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = b[i] + c[i] * d;
        }
    }

    public static void multiplyInto(double[] a, double[] b, double c) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = b[i] * c;
        }
    }

    public static double[] copyOf(double[] original, int newSize) {
        double[] a = new double[newSize];
        System.arraycopy(original, 0, a, 0, original.length);
        return a;
    }

    public static double entropy(double[] probs) {
        double e = 0.0;
        double p = 0.0;
        for (int i = 0; i < probs.length; ++i) {
            p = probs[i];
            if (p == 0.0) continue;
            e -= p * Math.log(p);
        }
        return e;
    }

    public static void assertFinite(double[] vector, String vectorName) throws InvalidElementException {
        for (int i = 0; i < vector.length; ++i) {
            if (Double.isNaN(vector[i])) {
                throw new InvalidElementException("NaN found in " + vectorName + " element " + i);
            }
            if (!Double.isInfinite(vector[i])) continue;
            throw new InvalidElementException("Infinity found in " + vectorName + " element " + i);
        }
    }

    public static class InvalidElementException
    extends RuntimeException {
        private static final long serialVersionUID = 1647150702529757545L;

        public InvalidElementException(String s) {
            super(s);
        }
    }
}

