# read in the command line arguments which is the agreements file
args <- commandArgs(TRUE)

# read in the agreements file into a table
data <- read.table(args[1])

# use ggplot2
library('ggplot2')

# create the agreement histogram
pdf('agreement-histogram.pdf')
p <- ggplot(data, aes(x=V1)) + geom_histogram(binwidth=5, colour="white", fill="black") + 
     opts(axis.text.x=theme_text(colour="black", size= 12, vjust=1, lineheight=0.9), 
          axis.text.y = theme_text(colour="black", size= 12, hjust=1, lineheight=0.9), 
          panel.background=theme_rect(fill="gray100"), 
          panel.grid.major=theme_blank(), 
          panel.grid.minor=theme_blank(), 
          strip.background=theme_rect(fill="white")) + 
     xlab("agreement")
     
# put the plot in the file
p
     
# close the file
dev.off()

